/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.types;

import com.pingcap.tidb.tipb.ExprType;
import java.math.BigDecimal;
import org.tikv.common.codec.Codec;
import org.tikv.common.codec.CodecDataInput;
import org.tikv.common.codec.CodecDataOutput;
import org.tikv.common.exception.ConvertNotSupportException;
import org.tikv.common.exception.ConvertOverflowException;
import org.tikv.common.exception.TypeException;
import org.tikv.common.meta.TiColumnInfo;
import org.tikv.common.types.Converter;
import org.tikv.common.types.DataType;
import org.tikv.common.types.MySQLType;
import org.tikv.shade.com.google.common.primitives.UnsignedLong;

public class IntegerType
extends DataType {
    public static final IntegerType TINYINT = new IntegerType(MySQLType.TypeTiny);
    public static final IntegerType SMALLINT = new IntegerType(MySQLType.TypeShort);
    public static final IntegerType MEDIUMINT = new IntegerType(MySQLType.TypeInt24);
    public static final IntegerType INT = new IntegerType(MySQLType.TypeLong);
    public static final IntegerType BIGINT = new IntegerType(MySQLType.TypeLonglong);
    public static final IntegerType BOOLEAN = TINYINT;
    public static final IntegerType YEAR = new IntegerType(MySQLType.TypeYear);
    public static final IntegerType ROW_ID_TYPE = new IntegerType(MySQLType.TypeLonglong, 2, 20, 0);
    public static final MySQLType[] subTypes = new MySQLType[]{MySQLType.TypeTiny, MySQLType.TypeShort, MySQLType.TypeInt24, MySQLType.TypeLong, MySQLType.TypeLonglong, MySQLType.TypeYear};

    protected IntegerType(MySQLType type, int flag, int len, int decimal) {
        super(type, flag, len, decimal, "", 83);
    }

    protected IntegerType(MySQLType tp) {
        super(tp);
    }

    protected IntegerType(TiColumnInfo.InternalTypeHolder holder) {
        super(holder);
    }

    private static BigDecimal unsignedValueOf(long x) {
        return new BigDecimal(UnsignedLong.fromLongBits(x).bigIntegerValue());
    }

    @Override
    protected Object doConvertToTiDBType(Object value) throws ConvertNotSupportException, ConvertOverflowException {
        if (this.getType() == MySQLType.TypeYear) {
            throw new ConvertNotSupportException(value.getClass().getName(), this.getClass().getName());
        }
        Long result = this.isUnsigned() ? Converter.safeConvertToUnsigned(value, this.unsignedUpperBound()) : Converter.safeConvertToSigned(value, this.signedLowerBound(), this.signedUpperBound());
        return result;
    }

    @Override
    public boolean isSameCatalog(DataType other) {
        return other instanceof IntegerType;
    }

    @Override
    protected Object decodeNotNull(int flag, CodecDataInput cdi) {
        long ret;
        switch (flag) {
            case 9: {
                ret = Codec.IntegerCodec.readUVarLong(cdi);
                break;
            }
            case 4: {
                ret = Codec.IntegerCodec.readULong(cdi);
                break;
            }
            case 8: {
                ret = Codec.IntegerCodec.readVarLong(cdi);
                break;
            }
            case 3: {
                ret = Codec.IntegerCodec.readLong(cdi);
                break;
            }
            default: {
                throw new TypeException("Invalid IntegerType flag: " + flag);
            }
        }
        if (this.isUnsignedLong()) {
            return IntegerType.unsignedValueOf(ret);
        }
        return ret;
    }

    @Override
    protected void encodeKey(CodecDataOutput cdo, Object value) {
        long longVal = Converter.convertToLong(value);
        if (this.isUnsigned()) {
            Codec.IntegerCodec.writeULongFully(cdo, longVal, true);
        } else {
            Codec.IntegerCodec.writeLongFully(cdo, longVal, true);
        }
    }

    @Override
    protected void encodeValue(CodecDataOutput cdo, Object value) {
        long longVal = Converter.convertToLong(value);
        if (this.isUnsigned()) {
            Codec.IntegerCodec.writeULongFully(cdo, longVal, false);
        } else {
            Codec.IntegerCodec.writeLongFully(cdo, longVal, false);
        }
    }

    @Override
    protected void encodeProto(CodecDataOutput cdo, Object value) {
        long longVal = Converter.convertToLong(value);
        if (this.isUnsigned()) {
            Codec.IntegerCodec.writeULong(cdo, longVal);
        } else {
            Codec.IntegerCodec.writeLong(cdo, longVal);
        }
    }

    @Override
    public String getName() {
        if (this.isUnsigned()) {
            return "UNSIGNED LONG";
        }
        return "LONG";
    }

    @Override
    public ExprType getProtoExprType() {
        return this.isUnsigned() ? ExprType.Uint64 : ExprType.Int64;
    }

    public boolean isUnsignedLong() {
        return this.tp == MySQLType.TypeLonglong && this.isUnsigned();
    }

    @Override
    public Object getOriginDefaultValueNonNull(String value, long version) {
        return Long.parseLong(value);
    }
}

