/*
 * Decompiled with CFR 0.152.
 */
package org.apache.subversion.javahl.callback;

import java.io.Serializable;

public interface RemoteStatus {
    public void addedDirectory(String var1);

    public void addedFile(String var1);

    public void addedSymlink(String var1);

    public void modifiedDirectory(String var1, boolean var2, boolean var3, Entry var4);

    public void modifiedFile(String var1, boolean var2, boolean var3, Entry var4);

    public void modifiedSymlink(String var1, boolean var2, boolean var3, Entry var4);

    public void deleted(String var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entry
    implements Comparable<Entry>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private String uuid;
        private String author;
        private long revision;
        private long timestamp;

        public Entry(String uuid, String author, long revision, long timestamp) {
            this.uuid = uuid;
            this.author = author;
            this.revision = revision;
            this.timestamp = timestamp;
        }

        public String getUuid() {
            return this.uuid;
        }

        public String getLastAuthor() {
            return this.author;
        }

        public long getCommittedRevision() {
            return this.revision;
        }

        public long getCommittedTimestamp() {
            return this.timestamp;
        }

        @Override
        public int compareTo(Entry that) {
            if (this == that) {
                return 0;
            }
            int cmp = this.uuid.compareTo(that.uuid);
            if (cmp == 0 && (cmp = this.author.compareTo(that.author)) == 0) {
                int n = this.revision < that.revision ? 1 : (cmp = this.revision > that.revision ? -1 : 0);
                if (cmp == 0) {
                    cmp = this.timestamp < that.timestamp ? 1 : (this.timestamp > that.timestamp ? -1 : 0);
                }
            }
            return cmp;
        }

        public boolean equals(Object entry) {
            if (this == entry) {
                return true;
            }
            if (!super.equals(entry) || this.getClass() != entry.getClass()) {
                return false;
            }
            Entry that = (Entry)entry;
            return this.uuid == that.uuid && this.author == that.author && this.revision == that.revision && this.timestamp == that.timestamp;
        }

        public int hashCode() {
            int factor = 33;
            int hash = this.uuid == null ? 0 : this.uuid.hashCode();
            hash = 33 * hash + (this.author == null ? 0 : this.author.hashCode());
            hash = 33 * hash + (int)(this.revision >> 32) & 0xFFFFFFFF;
            hash = 33 * hash + (int)this.revision & 0xFFFFFFFF;
            hash = 33 * hash + (int)(this.timestamp >> 32) & 0xFFFFFFFF;
            hash = 33 * hash + (int)this.timestamp & 0xFFFFFFFF;
            return hash;
        }
    }
}

