/*
 * Decompiled with CFR 0.152.
 */
package org.tohu.load.questionnaire;

import java.util.List;
import org.tohu.domain.questionnaire.Application;
import org.tohu.domain.questionnaire.Page;
import org.tohu.load.questionnaire.ExtractItems;
import org.tohu.load.questionnaire.SpreadsheetSectionConstants;
import org.tohu.load.spreadsheet.SpreadsheetRow;
import org.tohu.load.spreadsheet.sections.SpreadsheetSection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractPages
implements SpreadsheetSectionConstants {
    private Application application = null;
    private List<SpreadsheetSection> data;
    protected Page currentPage = null;
    protected String currentSheetName;

    public ExtractPages(List<SpreadsheetSection> theData, Application theApplication) {
        this.data = theData;
        this.application = theApplication;
    }

    public boolean processPages() {
        for (SpreadsheetSection section : this.data) {
            if (section.isProcessed() || this.processSectionData(section)) continue;
            System.out.println("Failed to process section " + section.getSectionHeadingString() + " for sheet " + section.getSheetName());
            return false;
        }
        return true;
    }

    protected boolean processSectionData(SpreadsheetSection section) {
        List<SpreadsheetRow> rows = section.getSectionRows();
        this.currentSheetName = section.getSheetName();
        if (section.getSectionHeadingString().startsWith("ITEM ID")) {
            this.currentPage = new ExtractItems(this.application, this.currentPage).processSectionData(section);
            if (this.currentPage == null) {
                System.out.println("Warning: no current page returned for section. " + section.toString());
                return true;
            }
            return true;
        }
        for (SpreadsheetRow spreadsheetRow : rows) {
            if (spreadsheetRow.getRowItems().size() == 0 || !section.getSectionHeadingString().startsWith("END")) continue;
            System.out.println("Did not expect to be processing a Sheet End section - ignoring!");
            break;
        }
        return true;
    }
}

