/*
 * Decompiled with CFR 0.152.
 */
package org.tohu.write.questionnaire;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import org.tohu.domain.questionnaire.Application;
import org.tohu.domain.questionnaire.PageElement;
import org.tohu.domain.questionnaire.framework.ConditionConstants;
import org.tohu.domain.questionnaire.framework.ListEntryTuple;
import org.tohu.domain.questionnaire.framework.PageElementConstants;
import org.tohu.write.questionnaire.WhenClauseTemplate;
import org.tohu.write.questionnaire.helpers.FieldTypeHelper;

public class PageElementTemplate
implements PageElementConstants,
ConditionConstants {
    protected PageElement element = null;

    public PageElementTemplate(PageElement element) {
        this.element = element;
    }

    protected String checkType(String itemId) {
        if (itemId.equals("Impact")) {
            return "TohuDataItemObject";
        }
        return itemId;
    }

    protected void writeFunctionalImpact(Application application, Formatter fmt) throws IOException {
        if (this.element.getLogicElement() == null) {
            throw new IllegalArgumentException("You cannot have an empty logical element for a functional impact!");
        }
        String functionName = null;
        String opName = this.element.getLogicElement().getOperation();
        if (opName == null) {
            throw new IllegalArgumentException("You cannot have an empty logical operation for a functional impact!");
        }
        if (opName.equalsIgnoreCase("max")) {
            functionName = "max";
        } else if (opName.equalsIgnoreCase("min")) {
            functionName = "min";
        } else if (opName.equalsIgnoreCase("average")) {
            functionName = "average";
        } else if (opName.equalsIgnoreCase("sum")) {
            functionName = "sum";
        } else if (opName.equalsIgnoreCase("count")) {
            functionName = "count";
        }
        if (functionName == null) {
            throw new IllegalArgumentException("Invalid operation " + opName + " for a functional impact!");
        }
        this.writeCreationOfAGlobalImpact(application, fmt);
        String tempFactName = "Temp" + this.element.getId();
        fmt.format("declare %s\n", tempFactName);
        fmt.format("\tnumber : Number\n", new Object[0]);
        fmt.format("end\n\n", new Object[0]);
        fmt.format("rule \"Function %s\"\nno-loop\n", this.element.getId());
        fmt.format("when\n", new Object[0]);
        fmt.format("\t$total : Number()\n", new Object[0]);
        fmt.format("\t\tfrom accumulate (%s(%s == \"%s\", answered == true, $value : %s),\n %s ( $value ) )\n", this.checkType(this.element.getLogicElement().getItemId()), this.element.getLogicElement().getItemAttribute(), this.element.getLogicElement().getValue(), FieldTypeHelper.mapFieldTypeToBaseVariableName(this.element.getFieldType()), functionName);
        fmt.format("then\n", new Object[0]);
        fmt.format("\t%s temp = new %s();\n", tempFactName, tempFactName);
        fmt.format("\ttemp.setNumber($total);\n", new Object[0]);
        fmt.format("\tinsert(temp);\n", new Object[0]);
        fmt.format("end\n\n", new Object[0]);
        fmt.format("rule \"Assign %s\"\nno-loop\n", this.element.getId());
        fmt.format("when\n", new Object[0]);
        fmt.format("\t$impact : %s(id == \"%s\");\n", "TohuDataItemObject", this.element.getId());
        fmt.format("\t$v : %s();\n", tempFactName);
        fmt.format("then\n", new Object[0]);
        fmt.format("\t$impact.setAnswer(new %s($v.getNumber().%s));\n", FieldTypeHelper.mapFieldTypeToJavaClassName(this.element.getFieldType()), FieldTypeHelper.mapFieldTypeToJavaNumberClassMethodName(this.element.getFieldType()));
        fmt.format("\tretract($v);\n", new Object[0]);
        fmt.format("\tupdate($impact);\n", new Object[0]);
        fmt.format("end\n\n", new Object[0]);
    }

    protected String writeCommonFactCreationCode(Application application, Formatter fmt, boolean showReason) throws IOException {
        String variableName = "a" + this.element.getType();
        fmt.format("\t%s %s = new %s(\"%s\");\n", this.element.getType(), variableName, this.element.getType(), this.element.getId());
        if (this.element.isAQuestionType() || this.element.isAnImpactType()) {
            String type = FieldTypeHelper.mapFieldTypeToQuestionType(this.element.getFieldType());
            fmt.format("\t%s.setAnswerType(%s);\n", variableName, type);
            if (this.element.getDefaultValueStr() != null) {
                String tempStr = FieldTypeHelper.formatValueStringAccordingToType(this.element.getDefaultValueStr(), this.element.getFieldType());
                fmt.format("\t%s.setAnswer(%s);\n", variableName, tempStr);
            }
            if (this.element.isAQuestionType() && this.element.isRequired()) {
                fmt.format("\t%s.setRequired(true);\n", variableName);
            }
            if (this.element.getCategory() != null) {
                fmt.format("\t%s.setCategory(\"%s\");\n", variableName, this.element.getCategory());
            }
            if (this.element.isAnImpactType() && showReason && this.element.getPostLabel() != null) {
                fmt.format("\t%s.setReason(\"%s\");\n", variableName, this.element.getPostLabel());
            }
        }
        if (this.element.getPreLabel() != null) {
            String methodText = this.element.isAQuestionType() ? "PreLabel" : (this.element.isAnImpactType() ? "Name" : "Label");
            fmt.format("\t%s.set%s(\"%s\");\n", variableName, methodText, this.element.getPreLabel());
        }
        return variableName;
    }

    protected void writeCreationOfAGlobalImpact(Application application, Formatter fmt) throws IOException {
        fmt.format("rule \"Create %s\"\ndialect \"mvel\"\nno-loop\nsalience 100\n", this.element.getId());
        fmt.format("then\n", new Object[0]);
        String variableName = this.writeCommonFactCreationCode(application, fmt, false);
        fmt.format("\tinsert(%s);\n", variableName);
        fmt.format("end\n\n", new Object[0]);
    }

    public void writeValidationDRLFileContents(Application application, Formatter fmt) throws IOException {
        fmt.format("rule \"Validate %s %d\"\n", this.element.getId(), this.element.getRowNumber());
        fmt.format("when\n", new Object[0]);
        new WhenClauseTemplate(this.element).writeLogicSectionDRLFileContents(application, fmt, false);
        String message = this.element.getPreLabel();
        this.element.setPreLabel(null);
        if (message == null) {
            message = "Invalid value";
            System.out.println("Warning - validation " + this.element.getId() + " has no validation message defined.");
        }
        fmt.format("then\n", new Object[0]);
        PageElement baseQuestion = this.element.findPreviousQuestion();
        if (baseQuestion == null) {
            throw new IllegalStateException("Validation " + this.element.getId() + " has no previous question to attach to.");
        }
        fmt.format("\tinsertLogical(new InvalidAnswer(\"%s\", \"%s\"));\n", baseQuestion.getId(), message);
        fmt.format("end\n\n", new Object[0]);
    }

    protected void writeSubItems(Application application, Formatter fmt, String variableName, boolean possibleAnswers) throws IOException {
        String newLine;
        if (possibleAnswers && (this.element.getLookupTable() == null || this.element.getLookupTable().getEntries().size() == 0)) {
            System.out.println("No entries for " + this.element.getId());
            return;
        }
        List<ListEntryTuple> entries = null;
        if (possibleAnswers) {
            entries = this.element.getLookupTable().getEntries();
        } else {
            if (this.element.getChildren() == null || this.element.getChildren().size() == 0) {
                throw new IllegalStateException("No children for group " + this.element.getId());
            }
            entries = new ArrayList<ListEntryTuple>();
            for (PageElement e : this.element.getChildren()) {
                if (e.isARepeatingElement()) {
                    PageElement temp = application.findPageElement(e.getId());
                    if (temp == null) {
                        throw new IllegalArgumentException("A repeating element has no master element for id " + e.getId());
                    }
                    e = temp;
                }
                if (!e.isAGroupType() && !e.isAQuestionType() && !e.isANoteType()) continue;
                entries.add(new ListEntryTuple(e.getId()));
            }
            if (entries.size() == 0) {
                throw new IllegalStateException("No group, note or question children for group " + this.element.getId());
            }
        }
        fmt.format("\t%s.", variableName);
        boolean firstOne = true;
        boolean onlyOne = entries.size() == 1;
        String indent = onlyOne ? "" : "\t\t";
        String string = newLine = onlyOne ? "" : "\n";
        if (possibleAnswers) {
            fmt.format("setPossibleAnswers({", new Object[0]);
        } else {
            fmt.format("setItems({", new Object[0]);
        }
        boolean wroteOne = false;
        for (ListEntryTuple tuple : entries) {
            if (possibleAnswers && tuple.getConditionClause() != null) continue;
            wroteOne = true;
            if (firstOne) {
                firstOne = false;
                fmt.format("%s", newLine);
            } else {
                fmt.format(",%s", newLine);
            }
            String idStr = tuple.getId();
            if (idStr != null && !idStr.startsWith("\"")) {
                idStr = "\"" + idStr + "\"";
            }
            if (possibleAnswers) {
                String rep = tuple.getRepresentation();
                if (rep != null && !rep.startsWith("\"")) {
                    rep = "\"" + rep + "\"";
                }
                if (tuple.getId() == null) {
                    fmt.format("%snew PossibleAnswer(null, %s)", indent, rep);
                    continue;
                }
                if (rep == null) {
                    fmt.format("%snew PossibleAnswer(%s)", indent, idStr);
                    continue;
                }
                fmt.format("%snew PossibleAnswer(%s, %s)", indent, idStr, rep);
                continue;
            }
            fmt.format("%s%s", indent, idStr);
        }
        if (!wroteOne) {
            throw new IllegalStateException("None of the items/possible answers for " + this.element.getId() + " were created as a default list. Mke sure at least one entry does not have a logic elements associated with it.");
        }
        fmt.format("});\n", new Object[0]);
    }

    protected void writeInitiateBranchPageDRLFileContents(Application application, Formatter fmt) throws IOException {
        if (!this.element.isABranchedPage()) {
            throw new IllegalArgumentException("Cannot process a normal page in writeInitiateBranchPageDRLFileContents :" + this.element.getId());
        }
        fmt.format("rule \"Branch %s\"\n", this.element.getId());
        fmt.format("salience 75\n", new Object[0]);
        fmt.format("no-loop\n", new Object[0]);
        fmt.format("when\n", new Object[0]);
        new WhenClauseTemplate(this.element).writeLogicSectionDRLFileContents(application, fmt, true);
        fmt.format("\tq : Questionnaire(items not contains \"%s\");\n", this.element.getId());
        fmt.format("then\n", new Object[0]);
        String insertAfter = "q.getActiveItem()";
        String displayAfter = this.element.getPostLabel();
        this.element.setPostLabel(null);
        if (displayAfter != null) {
            if (!displayAfter.startsWith("\"")) {
                displayAfter = "\"" + displayAfter + "\"";
            }
            insertAfter = displayAfter;
        }
        fmt.format("\tif (q.isBranched() == false) {\n\t\tq.navigationBranch(new String[]{\"%s\"}, \"%s\");\n", this.element.getId(), this.element.getId());
        fmt.format("\t}\n\telse {\n\t\tq.appendItem(\"%s\", %s);\n\t}\n", this.element.getId(), insertAfter);
        fmt.format("\tupdate(q);\n", new Object[0]);
        fmt.format("end\n\n", new Object[0]);
    }

    public void writeDRLFileContents(Application application, Formatter fmt) throws IOException {
        boolean useGroupIds;
        if (this.element.isARepeatingElement()) {
            System.out.println("Repeating item: " + this.element.getId());
            return;
        }
        if (this.element.isAFunctionImpactItem()) {
            this.writeFunctionalImpact(application, fmt);
            return;
        }
        if (this.element.isAnAlternateImpactItem()) {
            if (application.addNewAlternateImpact(this.element.getId())) {
                this.writeCreationOfAGlobalImpact(application, fmt);
            }
        } else {
            if (this.element.isAnImpactType() && this.element.getLogicElement() == null) {
                this.writeCreationOfAGlobalImpact(application, fmt);
                return;
            }
            if (this.element.isAValidationElement()) {
                this.writeValidationDRLFileContents(application, fmt);
                return;
            }
        }
        if (this.element.isABranchedPage()) {
            this.writeInitiateBranchPageDRLFileContents(application, fmt);
        }
        String ruleName = this.element.getId();
        if (this.element.isAnAlternateImpactItem()) {
            ruleName = ruleName + String.valueOf(this.element.getRowNumber());
        }
        fmt.format("rule \"%s\"\ndialect \"mvel\"\nno-loop\n", ruleName);
        boolean bl = useGroupIds = this.element.getGroupIds() != null && this.element.getGroupIds().size() > 0 && (this.element.isAQuestionType() || !this.element.isRequired());
        if (useGroupIds || this.element.getDisplayCondition() != null) {
            fmt.format("when\n", new Object[0]);
            if (useGroupIds) {
                fmt.format("\t$group : Group (", new Object[0]);
                Iterator<String> i = this.element.getGroupIds().iterator();
                while (i.hasNext()) {
                    String id = i.next();
                    if (!id.startsWith("\"")) {
                        id = "\"" + id + "\"";
                    }
                    fmt.format("id == %s%s", id, i.hasNext() ? " || " : "");
                }
                fmt.format(");\n", new Object[0]);
            }
            if (this.element.getDisplayCondition() != null) {
                new WhenClauseTemplate(this.element).writeLogicSectionDRLFileContents(application, fmt, false);
            }
        }
        if (this.element.isAnAlternateImpactItem()) {
            fmt.format("\taDataItem : %s (id == \"%s\")\n", "TohuDataItemObject", this.element.getId());
            fmt.format("then\n", new Object[0]);
            String tempStr = FieldTypeHelper.formatValueStringAccordingToType(this.element.getDefaultValueStr(), this.element.getFieldType());
            fmt.format("\taDataItem.setAnswer(%s);\n", tempStr);
            fmt.format("\tupdate(aDataItem);\n", new Object[0]);
        } else {
            fmt.format("then\n", new Object[0]);
            String variableName = this.writeCommonFactCreationCode(application, fmt, true);
            if (!this.element.isAnImpactType()) {
                if (this.element.getPostLabel() != null) {
                    fmt.format("\t%s.setPostLabel(\"%s\");\n", variableName, this.element.getPostLabel());
                }
                if (this.element.getType().equals("MultipleChoiceQuestion") || this.element.getType().equals("Group")) {
                    this.writeSubItems(application, fmt, variableName, this.element.getType().equals("MultipleChoiceQuestion"));
                }
                if (!this.element.getStyles().isEmpty()) {
                    boolean firstOne = true;
                    boolean onlyOne = this.element.getStyles().size() == 1;
                    String indent = onlyOne ? "" : "\t\t";
                    String newLine = onlyOne ? "" : "\n";
                    fmt.format("\t%s.setPresentationStyles({", variableName);
                    for (String style : this.element.getStyles()) {
                        if (firstOne) {
                            firstOne = false;
                            fmt.format("%s", newLine);
                        } else {
                            fmt.format(",%s", newLine);
                        }
                        if (style != null && !style.startsWith("\"")) {
                            style = "\"" + style + "\"";
                        }
                        fmt.format("%s%s", indent, style);
                    }
                    fmt.format("});\n", new Object[0]);
                }
            }
            fmt.format("\tinsertLogical(%s);\n", variableName);
        }
        fmt.format("end\n\n", new Object[0]);
    }
}

