/*
 * Decompiled with CFR 0.152.
 */
package org.tohu.domain.questionnaire;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tohu.domain.questionnaire.LookupTable;
import org.tohu.domain.questionnaire.Page;
import org.tohu.domain.questionnaire.PageElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Application {
    private String id;
    private String applicationClass;
    private String applicationName;
    private String completionAction;
    private String activePage;
    private String note;
    private String actionValidation = "false";
    private String markupAllowed = "false";
    private List<Page> pageList = new ArrayList<Page>();
    private List<String> imports = new ArrayList<String>();
    private List<PageElement> globalElements = new ArrayList<PageElement>();
    private Map<String, LookupTable> listTables = new HashMap<String, LookupTable>();
    private List<String> initiatedAlternateImpacts = new ArrayList<String>();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getActionValidation() {
        return this.actionValidation;
    }

    public void setActionValidation(String actionValidation) {
        this.actionValidation = actionValidation;
    }

    public LookupTable getLookupTable(String key) {
        return this.listTables.get(key);
    }

    public void addLookupTable(LookupTable table) {
        this.listTables.put(table.getId(), table);
    }

    public void addGlobalElement(PageElement element) {
        this.globalElements.add(element);
    }

    public List<PageElement> getGlobalElements() {
        return this.globalElements;
    }

    public void setApplicationClass(String applicationClass) {
        this.applicationClass = applicationClass;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public void setCompletionAction(String completionAction) {
        this.completionAction = completionAction;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public String getApplicationClass() {
        return this.applicationClass;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getCompletionAction() {
        return this.completionAction;
    }

    public String getActivePage() {
        return this.activePage;
    }

    public void setActivePage(String activePage) {
        this.activePage = activePage;
    }

    public String getMarkupAllowed() {
        return this.markupAllowed;
    }

    public void setMarkupAllowed(String markupAllowed) {
        this.markupAllowed = markupAllowed;
    }

    public void addImport(String name) {
        this.imports.add(name);
    }

    public List<String> getImports() {
        return this.imports;
    }

    public void addPage(Page thePage) {
        this.pageList.add(thePage);
    }

    public List<Page> getPageList() {
        return this.pageList;
    }

    public String getItemList() {
        String pageName;
        if (this.pageList.isEmpty()) {
            throw new IllegalStateException("You must have at least one page");
        }
        boolean found = false;
        ArrayList<String> orderedPages = new ArrayList<String>();
        for (int i = 0; i < this.pageList.size(); ++i) {
            Page pg = this.pageList.get(i);
            pageName = pg.getId();
            if (pg.isBranchedPage()) continue;
            if (pg.getDisplayAfter() != null) {
                int pos = orderedPages.indexOf(pg.getDisplayAfter());
                if (pos < 0 || pos == orderedPages.size() - 1) {
                    orderedPages.add(pageName);
                } else {
                    orderedPages.add(pos + 1, pageName);
                }
            } else {
                orderedPages.add(pageName);
            }
            found = true;
        }
        if (!found) {
            throw new IllegalStateException("You must have at least one non branched page to start with");
        }
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < orderedPages.size(); ++i) {
            pageName = (String)orderedPages.get(i);
            str = str.append(i > 0 ? ", \"" : "\"").append(pageName).append("\"");
        }
        return str.toString();
    }

    public PageElement findPageElement(String id) {
        if (id == null || id.length() == 0) {
            return null;
        }
        for (PageElement element : this.globalElements) {
            if (!element.getId().equals(id)) continue;
            return element;
        }
        for (Page pg : this.pageList) {
            PageElement element = pg.findElementOnThisPage(id);
            if (element == null) continue;
            return element;
        }
        return null;
    }

    public void processTableEntries() {
        for (Page pg : this.pageList) {
            pg.assignTables(this.listTables);
        }
    }

    public boolean addNewAlternateImpact(String id) {
        if (this.initiatedAlternateImpacts.contains(id)) {
            return false;
        }
        this.initiatedAlternateImpacts.add(id);
        return true;
    }
}

