/*
 * Decompiled with CFR 0.152.
 */
package org.tohu.load;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tohu.load.questionnaire.TohuSpreadsheetLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeriodicRuleLoader {
    private static final Logger logger = LoggerFactory.getLogger(PeriodicRuleLoader.class);
    private String ruleFile;
    private String outputDir;
    private String importDir;
    private String droolsDir;
    private int seconds = 5;
    private long lastUpdateTime;

    public static void main(String[] args) {
        if (args.length != 4) {
            throw new IllegalArgumentException("Must have three arguments");
        }
        PeriodicRuleLoader periodic = new PeriodicRuleLoader(args[0], args[1], args[2], args[3]);
        periodic.start();
    }

    public PeriodicRuleLoader(String ruleFile, String outputDir, String importDir, String droolsDir) {
        this.ruleFile = ruleFile;
        this.outputDir = outputDir;
        this.importDir = importDir;
        this.droolsDir = droolsDir;
        this.lastUpdateTime = System.currentTimeMillis();
    }

    public void setPeriodSeconds(int seconds) {
        this.seconds = seconds;
    }

    public void start() {
        boolean abort = false;
        File file = new File(this.ruleFile);
        if (!file.exists()) {
            abort = true;
            logger.debug("ERROR: Rule File does not exist: " + file.getAbsolutePath());
        }
        if (!(file = new File(this.outputDir)).exists()) {
            logger.debug("Warning: Output Directory does not exist: " + file.getAbsolutePath());
        }
        if (!(file = new File(this.importDir)).exists()) {
            abort = true;
            logger.debug("ERROR: Import Directory does not exist: " + file.getAbsolutePath());
        }
        if (!(file = new File(this.droolsDir)).exists()) {
            logger.debug("Warning: Drools Directory does not exist: " + file.getAbsolutePath());
        }
        if (abort) {
            throw new IllegalArgumentException("Required file or directory does not exist: " + this.ruleFile + " or " + this.importDir);
        }
        logger.debug("\n\nScanning every " + this.seconds + " seconds ...\n");
        while (true) {
            try {
                while (true) {
                    Thread.sleep((long)this.seconds * 1000L);
                    this.examineRules();
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    void examineRules() {
        File file = new File(this.ruleFile);
        logger.debug("Examining Rules");
        if (file.lastModified() > this.lastUpdateTime) {
            logger.debug("Rules updated, start conversion");
            this.lastUpdateTime = file.lastModified();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.loadRules();
            logger.debug("Rules updated, move files to drools directory: " + this.droolsDir);
            this.moveRules();
            logger.debug("Move complete");
        }
    }

    boolean loadRules() {
        TohuSpreadsheetLoader loader = new TohuSpreadsheetLoader();
        return loader.processFile(this.ruleFile, this.outputDir, this.importDir);
    }

    void moveRules() {
        File dir = new File(this.outputDir);
        ArrayList<File> list = new ArrayList<File>();
        this.gatherAllRuleFiles(dir, list);
        File destination = new File(this.droolsDir);
        for (File file : list) {
            File destFile = new File(destination + File.separator + file.getName());
            destFile.delete();
            boolean result = file.renameTo(destFile);
            if (result) continue;
            logger.error("Move failed for " + file.getName());
        }
    }

    void gatherAllRuleFiles(File file, List<File> list) {
        if (file.isDirectory()) {
            File[] contents;
            for (File subFile : contents = file.listFiles()) {
                this.gatherAllRuleFiles(subFile, list);
            }
            return;
        }
        if (file.getName().endsWith(".drl")) {
            list.add(file);
        }
    }
}

