/*
 * Decompiled with CFR 0.152.
 */
package org.tohu.load.questionnaire;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tohu.domain.questionnaire.Application;
import org.tohu.domain.questionnaire.Page;
import org.tohu.domain.questionnaire.PageElement;
import org.tohu.domain.questionnaire.conditions.ConditionClause;
import org.tohu.domain.questionnaire.conditions.PageElementCondition;
import org.tohu.load.questionnaire.SpreadsheetSectionConstants;
import org.tohu.load.spreadsheet.SpreadsheetItem;
import org.tohu.load.spreadsheet.SpreadsheetRow;
import org.tohu.load.spreadsheet.sections.SpreadsheetSection;

public class ExtractItems
implements SpreadsheetSectionConstants {
    private static final Logger logger = LoggerFactory.getLogger(ExtractItems.class);
    private Application application;
    protected Page currentPage;
    protected int currentDepth = 1;
    private List<PageElement> currentElementsAtDepth = new ArrayList<PageElement>();
    private List<Page> currentPageAtDepth = new ArrayList<Page>();
    private String currentSheetName;
    public static final String ELEMENT_PAGE_UPPER = "PAGE";
    public static final String ELEMENT_BRANCH_UPPER = "BRANCH";

    public ExtractItems(Application application, Page currentPage) {
        this.application = application;
        this.currentPage = currentPage;
    }

    protected void createNormalIntermediateGroup(PageElement element) {
        PageElement currentParent = this.getElementAtDepth(this.currentDepth);
        PageElement newGroup = new PageElement();
        String tempStr = "_CHILDREN";
        logger.debug("Warning: creating new Intermediate Group: " + currentParent.getId() + tempStr + " current depth = " + this.currentDepth);
        newGroup.setId(currentParent.getId() + tempStr, this.currentDepth, element.getRowNumber());
        newGroup.setType("Group");
        if (!currentParent.isAGroupType()) {
            currentParent = this.currentDepth == 1 ? this.currentPage.getParentPageElement() : this.getElementAtDepth(this.currentDepth - 1);
        }
        this.currentPage.addElement(newGroup);
        currentParent.addChild(newGroup);
        this.currentElementsAtDepth.set(this.currentDepth - 1, newGroup);
    }

    protected void setElementAtDepth(PageElement element) {
        int depth = element.getDepth();
        if (depth < 1 || depth > this.currentElementsAtDepth.size() + 1) {
            throw new IllegalArgumentException("Cannot set an element depth of " + String.valueOf(depth) + " when depth tree size is " + String.valueOf(this.currentElementsAtDepth.size()));
        }
        if (element.isAnImpactType()) {
            if (this.currentPage == null) {
                this.application.addGlobalElement(element);
                return;
            }
            if (depth == 1) {
                this.currentPage.getParentPageElement().addChild(element);
            } else {
                this.getElementAtDepth(depth - 1).addChild(element);
            }
            this.currentPage.addElement(element);
            return;
        }
        if (depth > 1 && depth > this.currentDepth && !this.getElementAtDepth(this.currentDepth).isAGroupType() && !element.isABranchedPage()) {
            this.createNormalIntermediateGroup(element);
        }
        if (!element.isAPageElement() && this.currentElementsAtDepth.size() == 0) {
            PageElement masterElement = new PageElement();
            masterElement.setId("DefaultPage", 0, 0);
            masterElement.setType("Page");
            this.currentPage = new Page(this.currentSheetName, masterElement, this.currentPage);
            this.application.addPage(this.currentPage);
        } else if (element.isAPageElement()) {
            this.currentPage = new Page(this.currentSheetName, element, this.currentPage);
            this.application.addPage(this.currentPage);
        }
        if (depth > this.currentElementsAtDepth.size()) {
            this.currentElementsAtDepth.add(element);
            this.currentPageAtDepth.add(this.currentPage);
        } else {
            this.currentElementsAtDepth.set(depth - 1, element);
            for (int i = this.currentElementsAtDepth.size() - 1; i >= depth; --i) {
                this.currentElementsAtDepth.remove(i);
                this.currentPageAtDepth.remove(i);
            }
            if (element.isAPageElement()) {
                this.currentPageAtDepth.set(depth - 1, this.currentPage);
            } else {
                this.currentPage = this.currentPageAtDepth.get(depth - 1);
            }
        }
        if (!element.isAPageElement()) {
            this.currentPage.addElement(element);
            PageElement tempElement = depth == 1 ? this.currentPage.getParentPageElement() : this.getElementAtDepth(depth - 1);
            tempElement.addChild(element);
        }
        this.currentDepth = element.getDepth();
    }

    protected PageElement getElementAtDepth(int depth) {
        if (depth < 1 || depth > this.currentElementsAtDepth.size()) {
            return null;
        }
        return this.currentElementsAtDepth.get(depth - 1);
    }

    public Page processSectionData(SpreadsheetSection section) {
        List<SpreadsheetRow> rows = section.getSectionRows();
        this.currentSheetName = section.getSheetName();
        PageElement lastRealElement = null;
        for (SpreadsheetRow spreadsheetRow : rows) {
            if (spreadsheetRow.getRowItems().size() == 0) continue;
            PageElement element = this.extractPageElement(section, spreadsheetRow);
            if (element.getId() != null) {
                this.setElementAtDepth(element);
                lastRealElement = element;
            }
            if (element.getLogicElement() == null || element.getLogicElement().isProcessed()) continue;
            if (lastRealElement.isAnImpactType()) {
                if (element.getId() != null) {
                    if (element.getLogicElement() == null) {
                        throw new IllegalArgumentException("You must specify a logic clause on an Impact " + element.getId());
                    }
                    element.setRequired("Yes");
                }
                this.processConditionClauseLine(lastRealElement, element, spreadsheetRow.getRowNumber());
                continue;
            }
            if (lastRealElement.isAValidationElement()) {
                this.processValidationClauseLine(lastRealElement, element, spreadsheetRow.getRowNumber());
                continue;
            }
            this.processConditionClauseLine(lastRealElement, element, spreadsheetRow.getRowNumber());
        }
        return this.currentPage;
    }

    protected PageElement extractPageElement(SpreadsheetSection section, SpreadsheetRow row) {
        PageElement element;
        block22: {
            SpreadsheetRow headings = section.getHeaderRow();
            element = new PageElement();
            for (SpreadsheetItem item : row.getRowItems()) {
                String key = headings.getHeaderTextForColumnInUpperCase(item.getColumn());
                if (key == null) {
                    logger.debug("Ignoring value: " + item);
                    continue;
                }
                String value = item.toString();
                if (key.startsWith("ITEM ID")) {
                    element.setId(value, section.getHeaderDepthForColumn(item.getColumn()), item.getRow());
                    continue;
                }
                if (key.startsWith("SET")) {
                    element.setDefaultValueStr(value);
                    continue;
                }
                if (key.startsWith("STYLE")) {
                    element.addStyle(value);
                    continue;
                }
                if (key.startsWith("TYPE")) {
                    element.setType(value);
                    continue;
                }
                if (key.startsWith("REQUIRE")) {
                    element.setRequired(value);
                    continue;
                }
                if (key.startsWith("DATA")) {
                    element.setFieldType(value);
                    continue;
                }
                if (key.startsWith("PRE")) {
                    element.setPreLabel(value);
                    continue;
                }
                if (key.startsWith("POST")) {
                    element.setPostLabel(value);
                    continue;
                }
                if (key.startsWith("SELECTION")) {
                    element.setLookupTableId(value);
                    continue;
                }
                if (key.startsWith("CATEGORY")) {
                    element.setCategory(value);
                    continue;
                }
                if (key.startsWith("DEPENDS")) {
                    element.setLogicDependsOnItemId(value);
                    continue;
                }
                if (key.startsWith("ATTRIBUTE")) {
                    element.setLogicAttribute(value);
                    continue;
                }
                if (key.startsWith("OPERATION")) {
                    element.setLogicOperation(value);
                    continue;
                }
                if (key.startsWith("VALUE")) {
                    element.setLogicValue(value);
                    continue;
                }
                logger.debug("Unknown Section key: " + key);
            }
            if (element.getId() != null && element.getType() == null) {
                throw new IllegalArgumentException("Row " + String.valueOf(row.getRowNumber() + 1) + " has no type!");
            }
            if (element.getType() != null && element.isAnImpactType() && element.getLogicElement() == null && this.currentPage != null) {
                try {
                    for (int depth = this.currentDepth; depth > 0; --depth) {
                        PageElement temp = this.getElementAtDepth(depth);
                        if (temp == null || temp.getLogicElement() == null) continue;
                        element.setDisplayCondition((PageElementCondition)temp.getDisplayCondition().clone());
                        element.setLogicElement(temp.getLogicElement());
                        depth = 0;
                    }
                    if (element.getLogicElement() != null) break block22;
                    if (this.currentPage.getParentPageElement().getLogicElement() != null) {
                        element.setDisplayCondition((PageElementCondition)this.currentPage.getParentPageElement().getDisplayCondition().clone());
                        element.setLogicElement(this.currentPage.getParentPageElement().getLogicElement());
                        break block22;
                    }
                    throw new IllegalArgumentException("Row " + String.valueOf(row.getRowNumber() + 1) + " has a impact with no condition or parent with a condition!");
                }
                catch (CloneNotSupportedException e) {
                    e.printStackTrace();
                    throw new IllegalStateException(e.getMessage());
                }
            }
        }
        return element;
    }

    protected void processValidationClauseLine(PageElement masterElement, PageElement element, int row) {
        ConditionClause le = element.getLogicElement();
        if (element.getId() != null) {
            String type = "Validation";
            masterElement.setDisplayCondition(new PageElementCondition(type, masterElement.getId(), row));
        }
        masterElement.getDisplayCondition().addElement(le);
        le.setProcessed(true);
    }

    protected void processConditionClauseLine(PageElement masterElement, PageElement element, int row) {
        ConditionClause le = element.getLogicElement();
        if (element.getId() != null) {
            String type = "Inclusion";
            if (masterElement.isAPageElement()) {
                masterElement.setDisplayCondition(new PageElementCondition(type, masterElement.getId(), row, this.currentPage.getId(), this.currentPage.isBranchedPage(), this.currentPage.getDisplayAfter()));
            } else if (masterElement.isAnAlternateImpactItem()) {
                le.setExplanation(element.getPostLabel());
                masterElement.setDisplayCondition(new PageElementCondition(type, masterElement.getId() + String.valueOf(row), row));
            } else {
                masterElement.setDisplayCondition(new PageElementCondition(type, masterElement.getId(), row));
            }
        }
        masterElement.getDisplayCondition().addElement(le);
        le.setProcessed(true);
    }
}

