/*
 * Decompiled with CFR 0.152.
 */
package org.tohu.load.questionnaire;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tohu.domain.questionnaire.Application;
import org.tohu.load.questionnaire.ExtractApplication;
import org.tohu.load.questionnaire.ExtractPages;
import org.tohu.load.questionnaire.SpreadsheetSectionConstants;
import org.tohu.load.spreadsheet.WorkbookData;
import org.tohu.load.spreadsheet.sections.SpreadsheetSection;
import org.tohu.load.spreadsheet.sections.SpreadsheetSectionSplitter;
import org.tohu.write.questionnaire.ApplicationTemplate;

public class TohuSpreadsheetLoader
implements SpreadsheetSectionConstants {
    private static final Logger logger = LoggerFactory.getLogger(TohuSpreadsheetLoader.class);
    public static final String SHEET_END = "END";
    private WorkbookData wbData;
    private Application application;
    private String outputDirectory;
    private String importDirectory;
    private boolean seperatePageDirectories = true;

    public boolean processFile(String filename, String outputDirectory, String importDirectory) {
        return this.processFile(filename, outputDirectory, importDirectory, true);
    }

    public boolean processFile(String filename, String outputDirectory, String importDirectory, boolean seperatePageDirectories) {
        this.wbData = new WorkbookData();
        this.outputDirectory = outputDirectory;
        this.importDirectory = importDirectory;
        this.seperatePageDirectories = seperatePageDirectories;
        if (!this.wbData.loadWorkbook(filename)) {
            logger.debug("Data not loaded from workbook");
            return false;
        }
        return this.processData(PAGE_SECTION_HEADINGS);
    }

    protected boolean processData(String[] sectionHeadingNames) {
        List<SpreadsheetSection> sections = new SpreadsheetSectionSplitter(sectionHeadingNames).splitIntoSections(this.wbData);
        this.application = new ExtractApplication(sections).processApp();
        if (this.application == null) {
            logger.debug("No Application Object Created");
            return false;
        }
        if (!new ExtractPages(sections, this.application).processPages()) {
            logger.debug("Page Extraction failed");
            return false;
        }
        this.application.processTableEntries();
        return this.createRuleFiles();
    }

    protected boolean createRuleFiles() {
        boolean processed = new ApplicationTemplate(this.application).generateDRLFile(this.outputDirectory, this.importDirectory, this.seperatePageDirectories);
        if (!processed) {
            logger.debug("Failed to create rule files");
        }
        return processed;
    }
}

