/*
 * Decompiled with CFR 0.152.
 */
package org.tohu.load.spreadsheet;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.tohu.load.spreadsheet.SpreadsheetItem;
import org.tohu.load.spreadsheet.SpreadsheetRow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpreadsheetData {
    private HashMap<String, SpreadsheetItem> data = new HashMap();
    private List<String> cellList = new ArrayList<String>(1000);
    private List<SpreadsheetRow> rows = new ArrayList<SpreadsheetRow>(12);
    private boolean processed;
    private SpreadsheetData parentSheet;
    private SpreadsheetItem firstItemOnSheet;
    private int keyColumn;
    private String sheetName;

    public SpreadsheetData(HSSFSheet sheet) {
        this.sheetName = sheet.getSheetName();
        for (Row row : sheet) {
            int rowNumber = row.getRowNum();
            SpreadsheetRow rowItems = new SpreadsheetRow(rowNumber);
            this.rows.add(rowItems);
            for (Cell cell : row) {
                if (cell == null || cell.getCellType() == 3 || this.keyColumn > 0 && cell.getColumnIndex() < this.keyColumn) continue;
                SpreadsheetItem item = new SpreadsheetItem(sheet.getSheetName(), cell);
                if (this.firstItemOnSheet == null) {
                    this.firstItemOnSheet = item;
                    this.keyColumn = cell.getColumnIndex();
                }
                String id = item.getCellIdentifier();
                this.data.put(id, item);
                rowItems.addRowItem(item);
                this.cellList.add(item.getCellIdentifier());
            }
        }
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public SpreadsheetItem getFirstItemOnSheet() {
        return this.firstItemOnSheet;
    }

    public SpreadsheetItem getItem(String cellReference) {
        return this.data.get(cellReference);
    }

    public List<String> getCellList() {
        return this.cellList;
    }

    public List<SpreadsheetRow> getRows() {
        return this.rows;
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public void setProcessed(boolean processed) {
        this.processed = processed;
    }

    public SpreadsheetData getParentSheet() {
        return this.parentSheet;
    }

    public void setParentSheet(SpreadsheetData parentSheet) {
        this.parentSheet = parentSheet;
    }

    public int getKeyColumn() {
        return this.keyColumn;
    }
}

