/*
 * Decompiled with CFR 0.152.
 */
package org.tohu.load.spreadsheet;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tohu.load.spreadsheet.SpreadsheetData;
import org.tohu.load.spreadsheet.SpreadsheetItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkbookData {
    private static final Logger logger = LoggerFactory.getLogger(WorkbookData.class);
    private HashMap<String, SpreadsheetData> data = new HashMap();
    private List<String> sheetList = new ArrayList<String>(20);

    public boolean loadWorkbook(String filename) {
        try {
            logger.debug("\n\n\nPROCESSING FILE: " + filename);
            FileInputStream inp = new FileInputStream(filename);
            HSSFWorkbook wb = new HSSFWorkbook(new POIFSFileSystem((InputStream)inp));
            for (int i = 0; i < wb.getNumberOfSheets(); ++i) {
                HSSFSheet sheet = wb.getSheetAt(i);
                SpreadsheetData sheetData = new SpreadsheetData(sheet);
                String sheetName = sheet.getSheetName();
                if (sheetName.indexOf("!") >= 0) {
                    logger.debug("Ignoring sheet named: " + sheetName);
                    continue;
                }
                this.data.put(sheetName, sheetData);
                this.sheetList.add(sheetName);
            }
            ((InputStream)inp).close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public SpreadsheetItem getItem(String currentSheet, String cellReference) {
        int pos = cellReference.indexOf(33);
        String tempSheet = currentSheet;
        if (pos > 0) {
            tempSheet = cellReference.substring(0, pos);
        } else {
            cellReference = tempSheet + "!" + cellReference;
        }
        return this.data.get(tempSheet).getItem(cellReference);
    }

    public List<String> getSheetCellList(String sheet) {
        return this.data.get(sheet).getCellList();
    }

    public List<String> getSheetList() {
        return this.sheetList;
    }

    public static List<String> convertCellRangeReferencesToExplicitCellReferences(String currentSheet, String cellReference) {
        throw new UnsupportedOperationException("convertCellRangeReferencesToExplicitCellReferences not yet supported");
    }

    public SpreadsheetData getSheet(String sheetName) {
        return this.data.get(sheetName);
    }
}

