/*
 * Decompiled with CFR 0.152.
 */
package org.tohu.load.spreadsheet.sections;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tohu.load.spreadsheet.SpreadsheetItem;
import org.tohu.load.spreadsheet.SpreadsheetRow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpreadsheetSection
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String sectionHeadingString;
    private List<SpreadsheetRow> sectionRows = new ArrayList<SpreadsheetRow>();
    private SpreadsheetRow headerRow;
    private Map<Integer, String> columnHeadingMap = new HashMap<Integer, String>();
    private Map<Integer, Integer> columnDepthMap = new HashMap<Integer, Integer>();
    private boolean processed;
    private String sheetName;

    public SpreadsheetSection(String sheetName, String sectionHeadingString, SpreadsheetRow headerRow) {
        if (headerRow == null) {
            throw new IllegalArgumentException("Null header row for " + sheetName + " " + sectionHeadingString);
        }
        this.sheetName = sheetName;
        this.sectionHeadingString = sectionHeadingString.toUpperCase();
        this.headerRow = headerRow;
        for (SpreadsheetItem item : headerRow.getRowItems()) {
            this.columnHeadingMap.put(new Integer(item.getColumn()), item.toString());
        }
        for (int i = 0; i < headerRow.getRowItems().size(); ++i) {
            SpreadsheetItem item;
            item = headerRow.getRowItems().get(i);
            int count = 1;
            String tempStr = item.toString().toUpperCase();
            for (int j = 0; j < i; ++j) {
                SpreadsheetItem previousItem = headerRow.getRowItems().get(j);
                if (!previousItem.toString().toUpperCase().equals(tempStr)) continue;
                ++count;
            }
            this.columnDepthMap.put(new Integer(item.getColumn()), new Integer(count));
        }
    }

    public String getSectionHeadingString() {
        return this.sectionHeadingString;
    }

    public List<SpreadsheetRow> getSectionRows() {
        return this.sectionRows;
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public void setProcessed(boolean processed) {
        this.processed = processed;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public SpreadsheetRow getHeaderRow() {
        return this.headerRow;
    }

    public SpreadsheetSection processSectionRow(String sheetName, SpreadsheetRow row, List<String> sectionHeadingStrings) {
        if (row.getRowItems().size() == 0) {
            return null;
        }
        for (String string : sectionHeadingStrings) {
            if (!row.getRowItems().get(0).toString().toUpperCase().startsWith(string)) continue;
            SpreadsheetSection newSection = new SpreadsheetSection(sheetName, row.getRowItems().get(0).toString().toUpperCase(), row);
            row.setHeaderRow(true);
            return newSection;
        }
        this.sectionRows.add(row);
        return null;
    }

    public String getHeaderStringForColumn(int column) {
        return this.columnHeadingMap.get(new Integer(column));
    }

    public Integer getHeaderDepthForColumn(int column) {
        return this.columnDepthMap.get(new Integer(column));
    }

    public String toString() {
        return String.format("headingString: %s, sheetName: %s, row: %d", this.sectionHeadingString, this.sheetName, this.headerRow == null ? 0 : this.headerRow.getRowNumber() + 1);
    }
}

