/*
 * Decompiled with CFR 0.152.
 */
package org.tohu.support;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

public class TohuDataItemObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String TYPE_TEXT = "text";
    public static final String TYPE_NUMBER = "number";
    public static final String TYPE_DECIMAL = "decimal";
    public static final String TYPE_BOOLEAN = "boolean";
    public static final String TYPE_DATE = "date";
    private String id;
    private String category;
    private String answerType;
    private String textAnswer;
    private Long numberAnswer;
    private BigDecimal decimalAnswer;
    private Boolean booleanAnswer;
    private Date dateAnswer;
    private String reason;
    private String name;

    public TohuDataItemObject() {
        this(null);
    }

    public TohuDataItemObject(String id) {
        this.setId(id);
    }

    public String getId() {
        return this.id;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public void setId(String id) {
        if (id == null || id.contains(",") || id.contains(".")) {
            throw new IllegalArgumentException("Invalid item id");
        }
        if (this.id != null && !this.id.equals(id)) {
            throw new IllegalStateException("id may not be changed");
        }
        this.id = id;
    }

    public String getAnswerType() {
        return this.answerType;
    }

    public void setAnswerType(String answerType) {
        String previousBasicAnswerType = this.answerTypeToBasicAnswerType(this.answerType);
        String basicAnswerType = this.answerTypeToBasicAnswerType(answerType);
        if (!(basicAnswerType != null && (basicAnswerType.equals(TYPE_TEXT) || basicAnswerType.equals(TYPE_NUMBER) || basicAnswerType.equals(TYPE_DECIMAL) || basicAnswerType.equals(TYPE_BOOLEAN) || basicAnswerType.equals(TYPE_DATE)))) {
            throw new IllegalArgumentException("answerType " + answerType + " is invalid");
        }
        this.answerType = answerType;
        if (!basicAnswerType.equals(previousBasicAnswerType)) {
            this.clearAnswer();
        }
    }

    public String getBasicAnswerType() {
        return this.answerTypeToBasicAnswerType(this.answerType);
    }

    protected String answerTypeToBasicAnswerType(String answerType) {
        if (answerType == null) {
            return null;
        }
        int i = answerType.indexOf(46);
        if (i >= 0) {
            return answerType.substring(0, i);
        }
        return answerType;
    }

    public void setAnswer(Object answer) {
        if (this.answerType == null) {
            throw new IllegalStateException("answerType has not been specified");
        }
        String basicAnswerType = this.getBasicAnswerType();
        if (basicAnswerType.equals(TYPE_TEXT)) {
            this.setTextAnswer((String)answer);
        }
        if (basicAnswerType.equals(TYPE_NUMBER)) {
            this.setNumberAnswer((Long)answer);
        }
        if (basicAnswerType.equals(TYPE_DECIMAL)) {
            this.setDecimalAnswer((BigDecimal)answer);
        }
        if (basicAnswerType.equals(TYPE_BOOLEAN)) {
            this.setBooleanAnswer((Boolean)answer);
        }
        if (basicAnswerType.equals(TYPE_DATE)) {
            this.setDateAnswer((Date)answer);
        }
    }

    public void checkType(String answerType) {
        if (this.answerType == null) {
            throw new IllegalStateException("answerType has not been specified");
        }
        String basicAnswerType = this.getBasicAnswerType();
        if (!basicAnswerType.equals(answerType)) {
            throw new IllegalStateException("Supplied answer type " + answerType + " differs from the expected type " + basicAnswerType + " for " + this.getId());
        }
    }

    public Object getAnswer() {
        if (this.answerType == null) {
            throw new IllegalStateException("answerType has not been specified");
        }
        String basicAnswerType = this.getBasicAnswerType();
        if (basicAnswerType.equals(TYPE_TEXT)) {
            return this.textAnswer;
        }
        if (basicAnswerType.equals(TYPE_NUMBER)) {
            return this.numberAnswer;
        }
        if (basicAnswerType.equals(TYPE_DECIMAL)) {
            return this.decimalAnswer;
        }
        if (basicAnswerType.equals(TYPE_BOOLEAN)) {
            return this.booleanAnswer;
        }
        if (basicAnswerType.equals(TYPE_DATE)) {
            return this.dateAnswer;
        }
        throw new IllegalStateException();
    }

    public String getTextAnswer() {
        this.checkType(TYPE_TEXT);
        return this.textAnswer;
    }

    public void setTextAnswer(String textAnswer) {
        this.checkType(TYPE_TEXT);
        this.textAnswer = textAnswer;
    }

    public Long getNumberAnswer() {
        this.checkType(TYPE_NUMBER);
        return this.numberAnswer;
    }

    public void setNumberAnswer(Long numberAnswer) {
        this.checkType(TYPE_NUMBER);
        this.numberAnswer = numberAnswer;
    }

    public BigDecimal getDecimalAnswer() {
        this.checkType(TYPE_DECIMAL);
        return this.decimalAnswer;
    }

    public void setDecimalAnswer(BigDecimal decimalAnswer) {
        this.checkType(TYPE_DECIMAL);
        this.decimalAnswer = decimalAnswer;
    }

    public Boolean getBooleanAnswer() {
        this.checkType(TYPE_BOOLEAN);
        return this.booleanAnswer;
    }

    public void setBooleanAnswer(Boolean booleanAnswer) {
        this.checkType(TYPE_BOOLEAN);
        this.booleanAnswer = booleanAnswer;
    }

    public Date getDateAnswer() {
        this.checkType(TYPE_DATE);
        return this.dateAnswer;
    }

    public void setDateAnswer(Date dateAnswer) {
        this.checkType(TYPE_DATE);
        this.dateAnswer = dateAnswer;
    }

    public boolean isAnswered() {
        return this.getAnswer() != null;
    }

    protected void clearAnswer() {
        this.textAnswer = null;
        this.numberAnswer = null;
        this.decimalAnswer = null;
        this.booleanAnswer = null;
        this.dateAnswer = null;
    }

    public String toString() {
        return this.getClass().getName() + ": id=" + this.id + " name=" + this.name + " answerType=" + this.getAnswerType() + " answer=" + this.getAnswer() + " category=" + this.getCategory();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TohuDataItemObject other = (TohuDataItemObject)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

