/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest.cli.api.interceptor.base;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.tomitribe.crest.api.interceptor.CrestContext;
import org.tomitribe.crest.api.interceptor.ParameterMetadata;
import org.tomitribe.util.editor.Converter;

public final class ParameterVisitor {
    private ParameterVisitor() {
    }

    public static void visit(CrestContext context, OptionVisitor visitor) {
        List parameters = context.getParameters();
        if (parameters != null) {
            ParameterVisitor.fillParams(visitor, parameters, context.getParameterMetadata(), context.getMethod().getParameterAnnotations());
        }
    }

    private static void fillParams(OptionVisitor visitor, List<Object> parameters, List<ParameterMetadata> metadata, Annotation[][] paramAnnotations) {
        block4: for (int i = 0; i < parameters.size(); ++i) {
            ParameterMetadata parameterMetadata = metadata.get(i);
            switch (parameterMetadata.getType()) {
                case OPTION: {
                    Object val;
                    if (parameters.get(i) != null || (val = visitor.onOption(i, parameterMetadata, new AnnotatedElementImpl(paramAnnotations[i]))) == null) continue block4;
                    parameters.set(i, val);
                    continue block4;
                }
                case BEAN_OPTION: {
                    Object fillBean = ParameterVisitor.fillBean(visitor, parameterMetadata.getReflectType(), parameters.get(i), parameterMetadata.getNested());
                    if (fillBean == null) continue block4;
                    parameters.set(i, fillBean);
                    continue block4;
                }
            }
        }
    }

    private static Object fillBean(OptionVisitor visitor, Type type, Object bean, List<ParameterMetadata> metadatas) {
        if (!Class.class.isInstance(type)) {
            return null;
        }
        ArrayList<Object> constructorParam = bean == null ? new ArrayList<Object>() : null;
        try {
            Constructor<?> constructor = ((Class)Class.class.cast(type)).getConstructors()[0];
            BeanInfo descriptor = Introspector.getBeanInfo((Class)Class.class.cast(type));
            HashMap<String, PropertyDescriptor> descriptorMap = new HashMap<String, PropertyDescriptor>();
            for (PropertyDescriptor d : descriptor.getPropertyDescriptors()) {
                descriptorMap.put(d.getName(), d);
            }
            Object value = bean;
            int consIdx = -1;
            for (ParameterMetadata metadata : metadatas) {
                Method write;
                Object val;
                PropertyDescriptor propertyDescriptor;
                String name;
                ++consIdx;
                if (metadata.getType() != ParameterMetadata.ParamType.OPTION || !descriptorMap.containsKey(name = metadata.getName().substring(metadata.getName().lastIndexOf(46) + 1)) || (propertyDescriptor = (PropertyDescriptor)descriptorMap.get(name)) == null) continue;
                if (bean != null) {
                    Method readMethod = propertyDescriptor.getReadMethod();
                    if (readMethod == null) continue;
                    try {
                        val = readMethod.invoke(bean, new Object[0]);
                        if (val != null) {
                            continue;
                        }
                    }
                    catch (IllegalAccessException e) {
                        throw new IllegalStateException(e);
                    }
                    catch (InvocationTargetException e) {
                        throw new IllegalStateException(e.getCause());
                    }
                }
                if ((write = propertyDescriptor.getWriteMethod()) == null || (val = visitor.onOption(consIdx, metadata, new AnnotatedElementImpl(write.getParameterAnnotations()[0]))) == null) continue;
                try {
                    if (value == null) {
                        constructorParam.add(val);
                        continue;
                    }
                    write.invoke(value, val);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
                catch (InvocationTargetException e) {
                    throw new IllegalStateException(e.getCause());
                }
            }
            if (value == null) {
                try {
                    value = constructor.newInstance(constructorParam.toArray(new Object[constructorParam.size()]));
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
                catch (InstantiationException e) {
                    throw new IllegalStateException(e);
                }
                catch (InvocationTargetException e) {
                    throw new IllegalStateException(e.getCause());
                }
            }
            return value;
        }
        catch (IntrospectionException e) {
            throw new IllegalStateException(e);
        }
    }

    private static class AnnotatedElementImpl
    implements AnnotatedElement {
        private final Annotation[] annotations;

        private AnnotatedElementImpl(Annotation[] annotations) {
            this.annotations = annotations;
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            for (Annotation a : this.annotations) {
                if (a.annotationType() != annotationClass) continue;
                return (T)a;
            }
            return null;
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
            return this.getAnnotation(annotationClass) != null;
        }

        @Override
        public Annotation[] getAnnotations() {
            return this.annotations;
        }

        @Override
        public Annotation[] getDeclaredAnnotations() {
            return this.getAnnotations();
        }
    }

    public static abstract class DefaultOptionVisitor
    implements OptionVisitor {
        protected abstract Object doOnOption(int var1, ParameterMetadata var2, AnnotatedElement var3);

        @Override
        public Object onOption(int index, ParameterMetadata meta, AnnotatedElement annotations) {
            return this.convert(meta, this.doOnOption(index, meta, annotations));
        }

        private Object convert(ParameterMetadata meta, Object o) {
            return o == null ? null : (String.class.isInstance(o) && String.class != meta.getReflectType() ? Converter.convertString((String)o.toString(), (Type)meta.getReflectType(), (String)meta.getName()) : o);
        }
    }

    public static interface OptionVisitor {
        public Object onOption(int var1, ParameterMetadata var2, AnnotatedElement var3);
    }
}

