/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest.cli.api.interceptor.interactive;

import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import org.tomitribe.crest.api.interceptor.CrestContext;
import org.tomitribe.crest.api.interceptor.CrestInterceptor;
import org.tomitribe.crest.api.interceptor.ParameterMetadata;
import org.tomitribe.crest.cli.api.CliEnvironment;
import org.tomitribe.crest.cli.api.interceptor.base.ParameterVisitor;
import org.tomitribe.crest.cli.api.interceptor.interactive.Interactivable;
import org.tomitribe.crest.environments.Environment;

public class InteractiveMissingParameters {
    private InteractiveMissingParameters() {
    }

    @CrestInterceptor
    public static Object intercept(CrestContext context) {
        ParameterVisitor.visit(context, new ParameterVisitor.DefaultOptionVisitor(){

            @Override
            public Object doOnOption(int index, ParameterMetadata meta, AnnotatedElement annotations) {
                return InteractiveMissingParameters.read(meta.getName(), annotations.getAnnotation(Interactivable.class));
            }
        });
        return context.proceed();
    }

    private static String read(String name, Interactivable interactivable) {
        String val;
        if (interactivable == null) {
            return null;
        }
        CliEnvironment e = (CliEnvironment)CliEnvironment.class.cast(Environment.ENVIRONMENT_THREAD_LOCAL.get());
        String prompt = "Enter " + name + ": ";
        try {
            val = interactivable.password() ? e.reader().readPassword(prompt) : e.reader().readLine(prompt);
        }
        catch (IOException readEx) {
            throw new IllegalStateException(readEx);
        }
        return "null".equals(val) ? null : val;
    }
}

