/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest.cmds;

import java.io.PrintStream;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.tomitribe.crest.cmds.Cmd;
import org.tomitribe.crest.cmds.CmdMethod;
import org.tomitribe.crest.cmds.processors.Help;
import org.tomitribe.crest.cmds.processors.OptionParam;
import org.tomitribe.crest.interceptor.internal.InternalInterceptor;
import org.tomitribe.util.Join;

public class OverloadedCmdMethod
implements Cmd {
    private final String name;
    private final Set<CmdMethod> methods;

    public OverloadedCmdMethod(String name) {
        this.name = name;
        this.methods = new TreeSet<CmdMethod>(new Comparator<CmdMethod>(){

            @Override
            public int compare(CmdMethod a, CmdMethod b) {
                return a.getArgumentParameters().size() - b.getArgumentParameters().size();
            }
        });
    }

    @Override
    public String getUsage() {
        StringBuilder sb = new StringBuilder();
        for (CmdMethod method : this.methods) {
            sb.append(method.getUsage()).append('\n');
        }
        return sb.toString().trim();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object exec(Map<Class<?>, InternalInterceptor> globalInterceptors, String ... rawArgs) {
        Iterator<CmdMethod> iterator = this.methods.iterator();
        while (iterator.hasNext()) {
            List<Object> args;
            CmdMethod method = iterator.next();
            try {
                args = method.parse(rawArgs);
            }
            catch (Exception e) {
                if (iterator.hasNext()) continue;
                throw CmdMethod.toRuntimeException(e);
            }
            return method.exec(globalInterceptors, args);
        }
        throw new IllegalStateException(String.format("Unable to find matching method for command: %s", Join.join((String)" ", (Object[])rawArgs)));
    }

    @Override
    public void help(PrintStream out) {
        if (this.methods.isEmpty()) {
            throw new IllegalStateException("No method in group: " + this.name);
        }
        out.println();
        Iterator<CmdMethod> it = this.methods.iterator();
        out.printf("Usage: %s%n", it.next().getUsage());
        while (it.hasNext()) {
            out.printf("       %s%n", it.next().getUsage());
        }
        out.println();
        TreeMap<String, OptionParam> options = new TreeMap<String, OptionParam>();
        for (CmdMethod method : this.methods) {
            options.putAll(method.getOptionParameters());
        }
        CmdMethod first = this.methods.iterator().next();
        Help.optionHelp(first.getMethod().getDeclaringClass(), this.getName(), options.values(), out);
    }

    public void add(CmdMethod cmd) {
        this.methods.add(cmd);
    }

    @Override
    public Collection<String> complete(String buffer, int cursorPosition) {
        throw new UnsupportedOperationException();
    }
}

