/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest.cmds;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.tomitribe.crest.api.Command;
import org.tomitribe.crest.api.CrestAnnotation;
import org.tomitribe.crest.api.Default;
import org.tomitribe.crest.api.Defaults;
import org.tomitribe.crest.api.Err;
import org.tomitribe.crest.api.Exit;
import org.tomitribe.crest.api.In;
import org.tomitribe.crest.api.NotAService;
import org.tomitribe.crest.api.Option;
import org.tomitribe.crest.api.Options;
import org.tomitribe.crest.api.Out;
import org.tomitribe.crest.api.Required;
import org.tomitribe.crest.api.interceptor.ParameterMetadata;
import org.tomitribe.crest.cmds.Cmd;
import org.tomitribe.crest.cmds.CmdGroup;
import org.tomitribe.crest.cmds.CommandFailedException;
import org.tomitribe.crest.cmds.HelpPrintedException;
import org.tomitribe.crest.cmds.MissingArgumentException;
import org.tomitribe.crest.cmds.processors.Commands;
import org.tomitribe.crest.cmds.processors.Help;
import org.tomitribe.crest.cmds.processors.Item;
import org.tomitribe.crest.cmds.processors.OptionParam;
import org.tomitribe.crest.cmds.processors.Param;
import org.tomitribe.crest.cmds.targets.SimpleBean;
import org.tomitribe.crest.cmds.targets.Substitution;
import org.tomitribe.crest.cmds.targets.Target;
import org.tomitribe.crest.cmds.utils.CommandLine;
import org.tomitribe.crest.contexts.DefaultsContext;
import org.tomitribe.crest.contexts.SystemPropertiesDefaultsContext;
import org.tomitribe.crest.environments.Environment;
import org.tomitribe.crest.help.CommandJavadoc;
import org.tomitribe.crest.help.Document;
import org.tomitribe.crest.help.DocumentFormatter;
import org.tomitribe.crest.help.DocumentParser;
import org.tomitribe.crest.interceptor.internal.InternalInterceptor;
import org.tomitribe.crest.interceptor.internal.InternalInterceptorInvocationContext;
import org.tomitribe.crest.javadoc.Javadoc;
import org.tomitribe.crest.javadoc.JavadocParser;
import org.tomitribe.crest.term.Screen;
import org.tomitribe.crest.val.BeanValidation;
import org.tomitribe.util.IO;
import org.tomitribe.util.Join;
import org.tomitribe.util.editor.Converter;
import org.tomitribe.util.reflect.Parameter;
import org.tomitribe.util.reflect.Reflection;

public class CmdMethod
implements Cmd {
    private static final String[] NO_PREFIX = new String[]{""};
    private static final Join.NameCallback<String> STRING_NAME_CALLBACK = new Join.NameCallback<String>(){

        public String getName(String object) {
            if (object.startsWith("-")) {
                return object;
            }
            if (object.length() > 1) {
                return "--" + object;
            }
            return "-" + object;
        }
    };
    private final Target target;
    private final Method method;
    private final String name;
    private final List<Param> parameters;
    private final Class<?>[] interceptors;
    private final DefaultsContext defaultsFinder;
    private final Spec spec = new Spec();
    private volatile List<ParameterMetadata> parameterMetadatas;

    public CmdMethod(Method method, DefaultsContext defaultsFinder) {
        this(method, new SimpleBean(null), defaultsFinder);
    }

    public CmdMethod(Method method, Target target, DefaultsContext defaultsFinder) {
        this.target = target;
        this.method = method;
        this.defaultsFinder = defaultsFinder;
        this.name = Commands.name(method);
        List<Param> parameters = this.buildParams(null, NO_PREFIX, null, Reflection.params((Method)method));
        this.parameters = Collections.unmodifiableList(parameters);
        Command cmdAnnotation = method.getAnnotation(Command.class);
        this.interceptors = cmdAnnotation == null ? null : cmdAnnotation.interceptedBy();
        this.validate();
    }

    private List<Param> buildParams(String globalDescription, String[] inPrefixes, Defaults.DefaultMapping[] defaultsMapping, Iterable<Parameter> params) {
        String[] prefixes = inPrefixes == null ? NO_PREFIX : inPrefixes;
        ArrayList<Param> parameters = new ArrayList<Param>();
        for (Parameter parameter : params) {
            if (parameter.isAnnotationPresent(Option.class)) {
                int i;
                Option option = (Option)parameter.getAnnotation(Option.class);
                Options options = parameter.getType().getAnnotation(Options.class);
                if (options != null) {
                    Defaults defaultMappings = (Defaults)parameter.getAnnotation(Defaults.class);
                    Defaults.DefaultMapping[] directMapping = (Defaults.DefaultMapping[])parameter.getDeclaredAnnotationsByType(Defaults.DefaultMapping.class);
                    ComplexParam complexParam = new ComplexParam(option.value(), option.description(), directMapping != null ? directMapping : defaultMappings.value(), parameter, options.nillable());
                    parameters.add(complexParam);
                    continue;
                }
                if (parameter.isAnnotationPresent(Defaults.class)) {
                    throw new IllegalArgumentException("Simple option doesnt support @Defaults, use @Default please");
                }
                String shortName = option.value()[0];
                String mainOption = prefixes[0] + shortName;
                String def = null;
                String description = option.description();
                if (defaultsMapping != null) {
                    for (Defaults.DefaultMapping mapping : defaultsMapping) {
                        if (!mapping.name().equals(shortName)) continue;
                        def = mapping.value();
                        if (mapping.description().isEmpty()) break;
                        def = mapping.description();
                        break;
                    }
                }
                OptionParam optionParam = new OptionParam(parameter, mainOption, def, (globalDescription != null ? globalDescription : "") + description);
                OptionParam existing = this.spec.options.put(mainOption, optionParam);
                if (existing != null) {
                    throw new IllegalArgumentException("Duplicate option: " + mainOption);
                }
                for (i = 1; i < prefixes.length; ++i) {
                    String key = prefixes[i] + optionParam.getName();
                    OptionParam existingAlias = this.spec.aliases.put(key, optionParam);
                    if (existingAlias == null) continue;
                    throw new IllegalArgumentException("Duplicate alias: " + key);
                }
                for (i = 1; i < option.value().length; ++i) {
                    String alias = option.value()[i];
                    for (String prefix : prefixes) {
                        String fullAlias = prefix + alias;
                        OptionParam existingAlias = this.spec.aliases.put(fullAlias, optionParam);
                        if (existingAlias == null) continue;
                        throw new IllegalArgumentException("Duplicate alias: " + fullAlias);
                    }
                }
                parameters.add(optionParam);
                continue;
            }
            if (parameter.getType().isAnnotationPresent(Options.class)) {
                ComplexParam complexParam = new ComplexParam(null, null, null, parameter, parameter.getType().getAnnotation(Options.class).nillable());
                parameters.add(complexParam);
                continue;
            }
            Param e = new Param(parameter);
            this.spec.arguments.add(e);
            parameters.add(e);
        }
        this.parameterMetadatas = this.buildApiParameterViews(parameters);
        return parameters;
    }

    public CmdMethod(Method method, Target target) {
        this(method, target, new SystemPropertiesDefaultsContext());
    }

    public Method getMethod() {
        return this.method;
    }

    public List<Param> getArgumentParameters() {
        return Collections.unmodifiableList(this.spec.arguments);
    }

    private void validate() {
        for (Param param : this.spec.arguments) {
            if (param.isAnnotationPresent(Default.class)) {
                throw new IllegalArgumentException("@Default only usable with @Option parameters.");
            }
            if (param.isListable() || !param.isAnnotationPresent(Required.class)) continue;
            throw new IllegalArgumentException("@Required only usable with @Option parameters and lists.");
        }
    }

    @Override
    public String getUsage() {
        String usage;
        String commandName = this.name;
        Class<?> declaringClass = this.method.getDeclaringClass();
        Map<String, Cmd> commands = Commands.get(declaringClass);
        if (commands.size() == 1 && commands.values().iterator().next() instanceof CmdGroup) {
            CmdGroup cmdGroup = (CmdGroup)commands.values().iterator().next();
            commandName = cmdGroup.getName() + " " + this.name;
        }
        if ((usage = this.usage()) != null) {
            if (!usage.startsWith(commandName)) {
                return commandName + " " + usage;
            }
            return usage;
        }
        ArrayList<String> args = new ArrayList<String>();
        for (Param parameter : this.spec.arguments) {
            boolean skip = Environment.class.isAssignableFrom(parameter.getType());
            for (Annotation a : parameter.getAnnotations()) {
                CrestAnnotation crestAnnotation = a.annotationType().getAnnotation(CrestAnnotation.class);
                if (crestAnnotation == null) continue;
                skip = crestAnnotation.skipUsage();
                break;
            }
            if (!skip) {
                boolean bl = skip = parameter.getAnnotation(NotAService.class) == null && Environment.ENVIRONMENT_THREAD_LOCAL.get().findService(parameter.getType()) != null;
            }
            if (skip) continue;
            args.add(parameter.getDisplayType().replace("[]", "..."));
        }
        return String.format("%s %s %s", commandName, args.size() == this.method.getParameterTypes().length ? "" : "[options]", Join.join((String)" ", args)).trim();
    }

    private String usage() {
        Command command = this.method.getAnnotation(Command.class);
        if (command == null) {
            return null;
        }
        if ("".equals(command.usage())) {
            return null;
        }
        return command.usage();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object exec(Map<Class<?>, InternalInterceptor> globalInterceptors, String ... rawArgs) {
        List<Object> list;
        try {
            list = this.parse(rawArgs);
        }
        catch (Exception e) {
            RuntimeException handled = this.getExitCode(e);
            if (handled != null) {
                Exit exit = handled.getClass().getAnnotation(Exit.class);
                if (exit.help()) {
                    this.reportWithHelp(e);
                }
                throw handled;
            }
            this.reportWithHelp(e);
            throw CmdMethod.toRuntimeException(e);
        }
        return this.exec(globalInterceptors, list);
    }

    private RuntimeException getExitCode(Throwable e) {
        if (e == null) {
            return null;
        }
        if (e instanceof RuntimeException && e.getClass().isAnnotationPresent(Exit.class)) {
            return (RuntimeException)e;
        }
        return this.getExitCode(e.getCause());
    }

    public Object exec(Map<Class<?>, InternalInterceptor> globalInterceptors, List<Object> list) {
        return this.interceptors == null || this.interceptors.length == 0 ? this.doInvoke(list) : new InternalInterceptorInvocationContext(globalInterceptors, this.interceptors, this.name, this.parameterMetadatas, this.method, list){

            @Override
            protected Object doInvoke(List<Object> parameters) {
                return CmdMethod.this.doInvoke(parameters);
            }
        }.proceed();
    }

    private List<ParameterMetadata> buildApiParameterViews(List<Param> parameters) {
        ArrayList<3> parameterMetadatas = new ArrayList<3>();
        for (final Param param : parameters) {
            ParameterMetadata.ParamType type;
            ParameterMetadata.ParamType paramType = OptionParam.class.isInstance((Object)param) ? ParameterMetadata.ParamType.OPTION : (ComplexParam.class.isInstance((Object)param) ? ParameterMetadata.ParamType.BEAN_OPTION : (Environment.class.isAssignableFrom(param.getType()) || param.getAnnotation(In.class) != null || param.getAnnotation(Out.class) != null || param.getAnnotation(Err.class) != null ? ParameterMetadata.ParamType.INTERNAL : (type = Environment.ENVIRONMENT_THREAD_LOCAL.get().findService(param.getType()) != null ? ParameterMetadata.ParamType.SERVICE : ParameterMetadata.ParamType.PLAIN)));
            if (type == ParameterMetadata.ParamType.INTERNAL) {
                if (param.isAnnotationPresent(In.class)) {
                    if (InputStream.class != param.getType()) {
                        throw new IllegalArgumentException("@In only supports InputStream injection");
                    }
                } else if (param.isAnnotationPresent(Out.class)) {
                    if (PrintStream.class != param.getType()) {
                        throw new IllegalArgumentException("@Out only supports PrintStream injection");
                    }
                } else if (param.isAnnotationPresent(Err.class) && PrintStream.class != param.getType()) {
                    throw new IllegalArgumentException("@Err only supports PrintStream injection");
                }
            }
            final String name = type == ParameterMetadata.ParamType.OPTION ? ((OptionParam)((Object)OptionParam.class.cast((Object)param))).getName() : null;
            final List<ParameterMetadata> nested = type == ParameterMetadata.ParamType.BEAN_OPTION ? this.buildApiParameterViews(((ComplexParam)((Object)ComplexParam.class.cast((Object)param))).parameters) : null;
            ParameterMetadata parameterMetadata = new ParameterMetadata(){

                public ParameterMetadata.ParamType getType() {
                    return type;
                }

                public String getName() {
                    return name;
                }

                public List<ParameterMetadata> getNested() {
                    return nested;
                }

                public Type getReflectType() {
                    return param.getGenericType();
                }

                public boolean isListable() {
                    return param.isListable();
                }

                public Class<?> getComponentType() {
                    return param.getListableType();
                }

                public String toString() {
                    return this.getType() + ": " + this.getReflectType() + ", name=" + this.getName() + ", nested=" + this.getNested();
                }
            };
            param.setApiView(parameterMetadata);
            parameterMetadatas.add(parameterMetadata);
        }
        return Collections.unmodifiableList(parameterMetadatas);
    }

    protected Object doInvoke(List<Object> list) {
        Object[] args;
        try {
            args = list.toArray();
            BeanValidation.validateParameters(this.target.getInstance(this.method), this.method, args);
        }
        catch (Exception e) {
            this.reportWithHelp(e);
            throw CmdMethod.toRuntimeException(e);
        }
        try {
            return this.target.invoke(this.method, args);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IllegalArgumentException) {
                this.reportWithHelp(e);
            }
            throw new CommandFailedException(cause, this.getName());
        }
        catch (Throwable e) {
            throw CmdMethod.toRuntimeException(e);
        }
    }

    private void reportWithHelp(Exception e) {
        PrintStream err = Environment.ENVIRONMENT_THREAD_LOCAL.get().getError();
        if (BeanValidation.isActive()) {
            for (String string : BeanValidation.messages(e)) {
                err.println(string);
            }
        } else {
            err.println(e.getMessage());
        }
        this.help(err);
        throw new HelpPrintedException(e);
    }

    public static RuntimeException toRuntimeException(Throwable e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new IllegalArgumentException(e);
    }

    public Map<String, OptionParam> getOptionParameters() {
        return Collections.unmodifiableMap(this.spec.options);
    }

    public Spec getSpec() {
        return this.spec;
    }

    @Override
    public void manual(PrintStream out) {
        boolean less;
        int width;
        Environment environment;
        CommandJavadoc commandJavadoc = CommandJavadoc.getCommandJavadocs(this.method, this.name);
        if (commandJavadoc == null) {
            this.help(out);
            return;
        }
        Javadoc javadoc = JavadocParser.parse(commandJavadoc.getJavadoc());
        Document.Builder manual = Document.builder().heading("NAME").paragraph(this.name).heading("SYNOPSIS").paragraph(this.getUsage());
        Document description = DocumentParser.parser(javadoc.getContent());
        if (description.getElements().size() > 0) {
            manual.heading("DESCRIPTION").inline(description);
        }
        if (this.spec.getOptions().size() > 0) {
            manual.heading("OPTIONS");
            List<Item> items = Help.getItems(this.method, this.name, this.spec.options.values(), commandJavadoc);
            for (Item item : items) {
                Document.Builder description2 = Document.builder();
                if (item.getDescription() != null) {
                    description2.inline(DocumentParser.parseOptionDescription(item.getDescription()));
                }
                if (CmdMethod.has(item.getNote())) {
                    String notes = Join.join((String)". ", item.getNote());
                    description2.paragraph(notes);
                }
                manual.element(new org.tomitribe.crest.help.Option(item.getFlag(), description2.build()));
            }
        }
        if (javadoc.getDeprecated() != null) {
            manual.heading("Deprecated");
            Javadoc.Deprecated deprecated = javadoc.getDeprecated();
            if (deprecated.getContent() == null || deprecated.getContent().length() == 0) {
                manual.paragraph("Command has been marked deprecated.");
            } else {
                manual.paragraph(deprecated.getContent());
            }
        }
        if (CmdMethod.has(javadoc.getSees())) {
            manual.heading("SEE ALSO");
            javadoc.getSees().forEach(see -> manual.paragraph(see.getContent()));
        }
        if (CmdMethod.has(javadoc.getAuthors())) {
            manual.heading("AUTHORS");
            javadoc.getAuthors().forEach(author -> manual.paragraph(author.getContent()));
        }
        boolean color = !(environment = Environment.ENVIRONMENT_THREAD_LOCAL.get()).getEnv().containsKey("NOCOLOR");
        int guess = Screen.guessWidth();
        int n = width = guess > 0 ? guess : 100;
        if (width > 120) {
            width -= 7;
        }
        DocumentFormatter formatter = new DocumentFormatter(width, color);
        String format = formatter.format(manual.build());
        boolean bl = less = !environment.getEnv().containsKey("NOLESS");
        if (!less) {
            out.print(format);
        } else {
            try {
                File tempFile = File.createTempFile("help-", ".txt");
                tempFile.deleteOnExit();
                IO.copy((InputStream)IO.read((String)format), (File)tempFile);
                Process process = new ProcessBuilder("less", "-r").inheritIO().redirectInput(tempFile).start();
                int n2 = process.waitFor();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw new IllegalStateException(e);
            }
        }
    }

    public static boolean has(List<?> list) {
        return list != null && list.size() > 0;
    }

    @Override
    public void help(PrintStream out) {
        out.println();
        out.print("Usage: ");
        out.println(this.getUsage());
        out.println();
        Help.optionHelp(this.method, this.getName(), this.spec.options.values(), out);
    }

    public List<Object> parse(String ... rawArgs) {
        return this.convert(new Arguments(rawArgs));
    }

    private <T> List<Object> convert(Arguments args) {
        Needed needed = new Needed(this.spec.arguments.size());
        List<Value> converted = this.convert(args, needed, this.parameters);
        if (!args.list.isEmpty()) {
            throw new IllegalArgumentException("Excess arguments: " + Join.join((String)", ", (Collection)args.list));
        }
        if (!args.options.isEmpty()) {
            throw new IllegalArgumentException("Unknown arguments: " + Join.join((String)", ", STRING_NAME_CALLBACK, args.options.keySet()));
        }
        return this.toArgs(converted);
    }

    private List<Object> toArgs(List<Value> converted) {
        ArrayList<Object> objects = new ArrayList<Object>(converted.size());
        for (Value v : converted) {
            objects.add(v.getValue());
        }
        return objects;
    }

    private List<Value> convert(Arguments args, Needed needed, List<Param> parameters1) {
        ArrayList<Value> converted = new ArrayList<Value>(args.options.size());
        Environment environment = Environment.ENVIRONMENT_THREAD_LOCAL.get();
        block7: for (Param parameter : parameters1) {
            ParameterMetadata apiView = parameter.getApiView();
            switch (apiView.getType()) {
                case INTERNAL: {
                    if (parameter.isAnnotationPresent(In.class)) {
                        converted.add(new Value(environment.getInput(), false));
                        needed.count--;
                        continue block7;
                    }
                    if (parameter.isAnnotationPresent(Out.class)) {
                        converted.add(new Value(environment.getOutput(), false));
                        needed.count--;
                        continue block7;
                    }
                    if (parameter.isAnnotationPresent(Err.class)) {
                        converted.add(new Value(environment.getError(), false));
                        needed.count--;
                        continue block7;
                    }
                    if (!Environment.class.isAssignableFrom(parameter.getType())) continue block7;
                    converted.add(new Value(environment, false));
                    needed.count--;
                    continue block7;
                }
                case SERVICE: {
                    converted.add(new Value(environment.findService(parameter.getType()), false));
                    continue block7;
                }
                case PLAIN: {
                    if (!args.list.isEmpty()) {
                        needed.count--;
                        converted.add(this.fillPlainParameter(args, needed, parameter));
                        continue block7;
                    }
                    throw new MissingArgumentException(parameter.getDisplayType().replace("[]", "..."));
                }
                case BEAN_OPTION: {
                    converted.add(((ComplexParam)((Object)ComplexParam.class.cast((Object)parameter))).convert(args, needed));
                    continue block7;
                }
                case OPTION: {
                    converted.add(this.fillOptionParameter(args, parameter, apiView.getName()));
                    continue block7;
                }
            }
            throw new IllegalStateException("Unsupported ParamType: " + apiView.getType());
        }
        return converted;
    }

    private Value fillOptionParameter(Arguments args, Param parameter, String name) {
        Object convert;
        String value = (String)args.options.remove(name);
        if (parameter.isListable()) {
            return CmdMethod.convert(parameter, OptionParam.getSeparatedValues(value), name);
        }
        try {
            convert = Converter.convert((Object)value, (Class)parameter.getType(), (String)name);
        }
        catch (IllegalArgumentException e) {
            if (e.getCause() != null && e.getCause() instanceof RuntimeException && e.getCause().getClass().isAnnotationPresent(Exit.class)) {
                throw (RuntimeException)e.getCause();
            }
            throw e;
        }
        return new Value(convert, value != null && !value.equals(((OptionParam)((Object)OptionParam.class.cast((Object)parameter))).getDefaultValue()));
    }

    private Value fillPlainParameter(Arguments args, Needed needed, Param parameter) {
        if (parameter.isListable()) {
            ArrayList<String> glob = new ArrayList<String>(args.list.size());
            for (int i = args.list.size(); i > needed.count; --i) {
                glob.add((String)args.list.remove(0));
            }
            return CmdMethod.convert(parameter, glob, null);
        }
        String value = (String)args.list.remove(0);
        return new Value(Converter.convert((Object)value, (Class)parameter.getType(), (String)parameter.getDisplayType().replace("[]", "...")), value != null);
    }

    private static Value convert(Param parameter, List<String> values, String name) {
        String description;
        Class type = parameter.getListableType();
        if (parameter.isAnnotationPresent(Required.class) && values.isEmpty()) {
            if (parameter instanceof OptionParam) {
                OptionParam optionParam = (OptionParam)parameter;
                throw new IllegalArgumentException(String.format("--%s must be specified at least once", optionParam.getName()));
            }
            throw new IllegalArgumentException(String.format("Argument for %s requires at least one value", parameter.getDisplayType().replace("[]", "...")));
        }
        String string = description = name == null ? "[" + type.getSimpleName() + "]" : name;
        if (Enum.class.isAssignableFrom(type) && CmdMethod.isBoolean(values)) {
            boolean all = "true".equals(values.get(0));
            values.clear();
            if (all) {
                Class elementType = type;
                EnumSet enums = EnumSet.allOf(elementType);
                Iterator iterator = enums.iterator();
                while (iterator.hasNext()) {
                    Enum e = (Enum)iterator.next();
                    values.add(e.name());
                }
            }
        }
        if (parameter.getType().isArray()) {
            Object array = Array.newInstance(type, values.size());
            int i = 0;
            for (String string2 : values) {
                Array.set(array, i++, Converter.convert((Object)string2, (Class)type, (String)description));
            }
            return new Value(array, !values.isEmpty());
        }
        Collection<Object> collection = CmdMethod.instantiate(parameter.getType());
        for (String string3 : values) {
            collection.add(Converter.convert((Object)string3, (Class)type, (String)description));
        }
        return new Value(collection, !collection.isEmpty());
    }

    private static boolean isBoolean(List<String> values) {
        if (values.size() != 1) {
            return false;
        }
        if ("true".equals(values.get(0))) {
            return true;
        }
        return "false".equals(values.get(0));
    }

    public static Collection<Object> instantiate(Class<? extends Collection> aClass) {
        if (aClass.isInterface()) {
            if (NavigableSet.class.isAssignableFrom(aClass)) {
                return new TreeSet<Object>();
            }
            if (SortedSet.class.isAssignableFrom(aClass)) {
                return new TreeSet<Object>();
            }
            if (Set.class.isAssignableFrom(aClass)) {
                return new LinkedHashSet<Object>();
            }
            if (Deque.class.isAssignableFrom(aClass)) {
                return new LinkedList<Object>();
            }
            if (Queue.class.isAssignableFrom(aClass)) {
                return new LinkedList<Object>();
            }
            if (List.class.isAssignableFrom(aClass)) {
                return new ArrayList<Object>();
            }
            if (Collection.class.isAssignableFrom(aClass)) {
                return new LinkedList<Object>();
            }
            if (Iterable.class.isAssignableFrom(aClass)) {
                return new LinkedList<Object>();
            }
            throw new IllegalStateException("Unsupported Collection type: " + aClass.getName());
        }
        if (Modifier.isAbstract(aClass.getModifiers())) {
            throw new IllegalStateException("Unsupported Collection type: " + aClass.getName() + " - Type is Abstract");
        }
        try {
            Constructor<? extends Collection> constructor = aClass.getConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Unsupported Collection type: " + aClass.getName() + " - No default constructor");
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot construct java.util.Collection type: " + aClass.getName(), e);
        }
    }

    public Map<String, String> getDefaults() {
        HashMap<String, String> options = new HashMap<String, String>();
        for (OptionParam parameter : this.spec.options.values()) {
            options.put(parameter.getName(), parameter.getDefaultValue());
        }
        return options;
    }

    public String toString() {
        return "Command{name='" + this.name + '\'' + '}';
    }

    @Override
    public Collection<String> complete(String buffer, int cursorPosition) {
        ArrayList<String> result = new ArrayList<String>();
        String commandLine = buffer.substring(0, cursorPosition);
        String[] args = CommandLine.translateCommandline(commandLine);
        if (args != null && args.length > 0) {
            String lastArg = args[args.length - 1];
            if (lastArg.startsWith("--")) {
                result.addAll(this.findMatchingOptions(lastArg.substring(2), false));
            } else if (lastArg.startsWith("-")) {
                result.addAll(this.findMatchingOptions(lastArg.substring(1), true));
            }
        }
        return result;
    }

    private Collection<String> findMatcingParametersOptions(String prefix, boolean isIncludeAliasChar) {
        ArrayList<String> result = new ArrayList<String>();
        for (Param param : this.parameters) {
            OptionParam optionParam;
            String optionParamName;
            if (!(param instanceof OptionParam) || !(optionParamName = (optionParam = (OptionParam)param).getName()).startsWith(prefix)) continue;
            if (optionParamName.startsWith("-")) {
                result.add(optionParamName);
                continue;
            }
            if (optionParamName.length() > 1) {
                result.add("--" + optionParamName);
                continue;
            }
            if (!isIncludeAliasChar) continue;
            result.add("-" + optionParamName);
        }
        return result;
    }

    private Collection<String> findMatchingAliasOptions(String prefix, boolean isIncludeAliasChar) {
        ArrayList<String> result = new ArrayList<String>();
        for (String alias : this.spec.aliases.keySet()) {
            if (!alias.startsWith(prefix)) continue;
            if (alias.startsWith("-")) {
                result.add(alias);
            } else if (alias.length() > 1) {
                result.add("--" + alias);
            }
            if (!isIncludeAliasChar || alias.length() != 1) continue;
            result.add("-" + alias);
        }
        return result;
    }

    private Collection<String> findMatchingOptions(String prefix, boolean isIncludeAliasChar) {
        ArrayList<String> results = new ArrayList<String>();
        results.addAll(this.findMatcingParametersOptions(prefix, isIncludeAliasChar));
        results.addAll(this.findMatchingAliasOptions(prefix, isIncludeAliasChar));
        return results;
    }

    public static final class Value {
        private final Object value;
        private final boolean provided;

        protected Value(Object value, boolean provided) {
            this.value = value;
            this.provided = provided;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean isProvided() {
            return this.provided;
        }
    }

    private class Arguments {
        private final List<String> list = new ArrayList<String>();
        private final Map<String, String> options = new HashMap<String, String>();

        private Arguments(String[] rawArgs) {
            Map<String, String> defaults = CmdMethod.this.getDefaults();
            HashMap<String, String> supplied = new HashMap<String, String>();
            ArrayList<String> invalid = new ArrayList<String>();
            HashSet<String> repeated = new HashSet<String>();
            for (String arg : rawArgs) {
                if (arg.startsWith("--")) {
                    this.getCommand("--", arg, defaults, supplied, invalid, repeated);
                    continue;
                }
                if (arg.startsWith("-")) {
                    this.getCommand("-", arg, defaults, supplied, invalid, repeated);
                    continue;
                }
                this.list.add(arg);
            }
            this.checkInvalid(invalid);
            this.checkRequired(supplied);
            this.checkRepeated(repeated);
            this.interpret(defaults);
            this.options.putAll(defaults);
            this.options.putAll(supplied);
        }

        private void getCommand(String defaultPrefix, String arg, Map<String, String> defaults, Map<String, String> supplied, List<String> invalid, Set<String> repeated) {
            String value;
            String name;
            String prefix = defaultPrefix;
            if (arg.indexOf(61) > 0) {
                name = arg.substring(arg.indexOf(prefix) + prefix.length(), arg.indexOf(61));
                if (!defaults.containsKey(name) && !CmdMethod.this.spec.aliases.containsKey(name)) {
                    name = arg.substring(0, arg.indexOf(61));
                    prefix = "";
                }
                value = arg.substring(arg.indexOf(61) + 1);
            } else if (arg.startsWith("--no-")) {
                name = arg.substring(5);
                value = "false";
            } else {
                name = arg.substring(prefix.length());
                value = "true";
            }
            if ("-".equals(prefix)) {
                if (arg.indexOf(61) > -1 && name.length() > 1) {
                    invalid.add(prefix + name);
                    return;
                }
                HashSet<String> opts = new HashSet<String>();
                for (String opt : name.split("(?!^)")) {
                    opts.add(opt);
                }
                for (String opt : opts) {
                    this.processOption(prefix, opt, value, defaults, supplied, invalid, repeated);
                }
            }
            if ("--".equals(prefix)) {
                if (name.length() == 1) {
                    invalid.add(prefix + name);
                    return;
                }
                this.processOption(prefix, name, value, defaults, supplied, invalid, repeated);
            }
            if (prefix.isEmpty()) {
                this.processOption(prefix, name, value, defaults, supplied, invalid, repeated);
            }
        }

        private void processOption(String prefix, String optName, String optValue, Map<String, String> defaults, Map<String, String> supplied, List<String> invalid, Set<String> repeated) {
            String name = optName;
            String value = optValue;
            if (!defaults.containsKey(name) && CmdMethod.this.spec.aliases.containsKey(name)) {
                name = ((OptionParam)((Object)CmdMethod.this.spec.aliases.get(name))).getName();
            }
            if (defaults.containsKey(name)) {
                boolean isList = defaults.get(name) != null && defaults.get(name).startsWith("\uffff\uffff");
                String existing = supplied.get(name);
                if (isList) {
                    value = existing == null ? "\uffff\uffff" + value : existing + "\u0000" + value;
                } else if (existing != null) {
                    repeated.add(name);
                }
                supplied.put(name, value);
            } else {
                invalid.add(prefix + name);
            }
        }

        private void interpret(Map<String, String> map) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (entry.getValue() == null) continue;
                String value = Substitution.format(CmdMethod.this.target, CmdMethod.this.method, entry.getValue(), CmdMethod.this.defaultsFinder);
                map.put(entry.getKey(), value);
            }
        }

        private void checkInvalid(List<String> invalid) {
            if (!invalid.isEmpty()) {
                throw new IllegalArgumentException("Unknown options: " + Join.join((String)", ", (Join.NameCallback)STRING_NAME_CALLBACK, invalid));
            }
        }

        private void checkRequired(Map<String, String> supplied) {
            ArrayList<String> required = new ArrayList<String>();
            for (Param parameter : CmdMethod.this.spec.options.values()) {
                if (!parameter.isAnnotationPresent(Required.class)) continue;
                Option option = (Option)parameter.getAnnotation(Option.class);
                for (String optionValue : option.value()) {
                    if (supplied.containsKey(optionValue)) continue;
                    required.add(optionValue);
                }
            }
            if (!required.isEmpty()) {
                throw new IllegalArgumentException("Required: " + Join.join((String)", ", (Join.NameCallback)STRING_NAME_CALLBACK, required));
            }
        }

        private void checkRepeated(Set<String> repeated) {
            if (!repeated.isEmpty()) {
                throw new IllegalArgumentException("Cannot be specified more than once: " + Join.join((String)", ", repeated));
            }
        }
    }

    public class Needed {
        private int count;

        public Needed(int count) {
            this.count = count;
        }
    }

    private class ComplexParam
    extends Param {
        private final List<Param> parameters;
        private final Constructor<?> constructor;
        private final boolean nullable;

        private ComplexParam(String[] prefixes, String globalDescription, Defaults.DefaultMapping[] defaults, Parameter parent, boolean nullable) {
            super(parent);
            this.constructor = parent.getType().getConstructors()[0];
            this.parameters = Collections.unmodifiableList(CmdMethod.this.buildParams(globalDescription, prefixes, defaults, Reflection.params(this.constructor)));
            this.nullable = nullable;
        }

        public Value convert(Arguments arguments, Needed needed) {
            List converted = CmdMethod.this.convert(arguments, needed, this.parameters);
            if (this.nullable) {
                boolean allNull = true;
                for (Value val : converted) {
                    if (!val.isProvided()) continue;
                    allNull = false;
                    break;
                }
                if (allNull) {
                    return new Value(null, false);
                }
            }
            try {
                Object[] args = CmdMethod.this.toArgs(converted).toArray(new Object[converted.size()]);
                BeanValidation.validateParameters(this.constructor, args);
                return new Value(this.constructor.newInstance(args), true);
            }
            catch (InvocationTargetException e) {
                throw CmdMethod.toRuntimeException(e.getCause());
            }
            catch (Exception e) {
                throw CmdMethod.toRuntimeException(e);
            }
        }
    }

    public class Spec {
        private final Map<String, OptionParam> options = new TreeMap<String, OptionParam>();
        private final Map<String, OptionParam> aliases = new TreeMap<String, OptionParam>();
        private final List<Param> arguments = new LinkedList<Param>();

        public Map<String, OptionParam> getOptions() {
            return Collections.unmodifiableMap(this.options);
        }

        public Map<String, OptionParam> getAliases() {
            return Collections.unmodifiableMap(this.aliases);
        }

        public List<Param> getArguments() {
            return Collections.unmodifiableList(this.arguments);
        }
    }
}

