/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest.cmds.targets;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.tomitribe.crest.cmds.targets.Target;
import org.tomitribe.crest.contexts.DefaultsContext;
import org.tomitribe.crest.contexts.EnvDefaultsContext;
import org.tomitribe.crest.contexts.SystemPropertiesDefaultsContext;
import org.tomitribe.crest.lang.Substitutor;

public class Substitution {
    private static final Map<String, DefaultsContext> DEFAULTS_JVM_CONTEXTS = new HashMap<String, DefaultsContext>(){
        {
            this.put("env.", new EnvDefaultsContext());
            this.put("sys.", new SystemPropertiesDefaultsContext());
            for (DefaultsContext defaultsContext : ServiceLoader.load(DefaultsContext.class)) {
                this.put(defaultsContext.getClass().getSimpleName().toLowerCase(Locale.ROOT), defaultsContext);
            }
        }
    };

    private Substitution() {
    }

    public static String format(Target target, Method method, String input, DefaultsContext df) {
        return Substitution.format(target, method, input, df, new HashSet<String>());
    }

    private static String format(final Target target, final Method method, String input, final DefaultsContext df, Set<String> seen) {
        if (!seen.add(input)) {
            throw new IllegalStateException("Circular reference in " + input);
        }
        return new Substitutor(){

            @Override
            protected String getOrDefault(String varName, String varDefaultValue) {
                for (Map.Entry ctx : DEFAULTS_JVM_CONTEXTS.entrySet()) {
                    String value;
                    if (!varName.startsWith((String)ctx.getKey()) || (value = ((DefaultsContext)ctx.getValue()).find(target, method, varName.substring(((String)ctx.getKey()).length()))) == null) continue;
                    return value;
                }
                String value = df.find(target, method, varName);
                return value == null ? varDefaultValue : value;
            }
        }.replace(input);
    }
}

