/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.tomitribe.crest.help.Justify;
import org.tomitribe.crest.table.Lines;
import org.tomitribe.crest.table.Tables;
import org.tomitribe.crest.table.Width;

public class Data {
    private final Row[] rows;
    private final Column[] columns;
    private final Cell[][] cells;
    private final Width width;
    private final int height;
    private final boolean heading;

    public Data(String[][] data, boolean headings) {
        this.heading = headings;
        this.cells = Tables.createCells(this, data);
        this.rows = Tables.createRows(this, this.cells);
        this.columns = Tables.createColumns(this, this.cells);
        this.width = Stream.of(this.columns).map(Column::getWidth).reduce(Width::add).orElse(Width.ZERO);
        this.height = Stream.of(this.rows).mapToInt(Row::getHeight).reduce(Integer::sum).orElse(0);
    }

    Data(Cell[][] cells, Data previous) {
        this.heading = previous.heading;
        this.cells = cells;
        this.rows = Tables.createRows(this, this.cells);
        this.columns = Tables.createColumns(this, this.cells);
        this.width = Stream.of(this.columns).map(Column::getWidth).reduce(Width::add).orElse(Width.ZERO);
        this.height = Stream.of(this.rows).mapToInt(Row::getHeight).reduce(Integer::sum).orElse(0);
    }

    public boolean hasHeading() {
        return this.heading;
    }

    public Width getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public List<Column> getColumns() {
        return Arrays.asList(this.columns);
    }

    public List<Row> getRows() {
        return Arrays.asList(this.rows);
    }

    public Column getColumn(int i) {
        return this.columns[i];
    }

    public Row getRow(int i) {
        return this.rows[i];
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final List<String[]> rows = new ArrayList<String[]>();
        private boolean headings;

        public Builder row(String ... columns) {
            this.rows.add(columns);
            return this;
        }

        public Builder headings(boolean headings) {
            this.headings = headings;
            return this;
        }

        public Data build() {
            String[][] data = (String[][])this.rows.toArray((T[])new String[0][]);
            return new Data(data, this.headings);
        }
    }

    public class Cell {
        private final String data;
        private final int row;
        private final int column;
        private final Width width;
        private final List<String> lines;

        public Cell(int row, int column, String data) {
            this(row, column, data, Lines.split(data));
        }

        private Cell(int row, int column, String data, String[] lines) {
            this.data = data;
            this.row = row;
            this.column = column;
            this.lines = Collections.unmodifiableList(Arrays.asList(lines));
            this.width = this.lines.stream().map(Width::ofString).reduce(Width::adjust).orElse(Width.ZERO);
        }

        public List<String> getLines() {
            return this.lines;
        }

        public int getHeight() {
            return this.lines.size();
        }

        public int getRow() {
            return this.row;
        }

        public int getColumn() {
            return this.column;
        }

        public Width getWidth() {
            return this.width;
        }

        public String getData() {
            return this.data;
        }

        public Cell resizeTo(int width) {
            String wrapped = Justify.wrapAndJustify(this.data, width);
            return new Cell(this.row, this.column, this.data, Lines.split(wrapped));
        }
    }

    public class Column {
        private final int index;
        private final Width width;
        private final boolean numeric;

        public Column(int index, Width width, boolean numeric) {
            this.index = index;
            this.width = width;
            this.numeric = numeric;
        }

        public int getIndex() {
            return this.index;
        }

        public Width getWidth() {
            return this.width;
        }

        public boolean isNumeric() {
            return this.numeric;
        }

        public Stream<Cell> stream() {
            return Tables.cellsInColumn(Data.this.cells, this.index);
        }
    }

    public class Row {
        private final int row;
        private final Width width;
        private final int height;

        public Row(int row, Width width, int height) {
            this.row = row;
            this.width = width;
            this.height = height;
        }

        public Stream<Cell> stream() {
            return Stream.of(Data.this.cells[this.row]);
        }

        public int getRow() {
            return this.row;
        }

        public Width getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public int length() {
            return Data.this.cells[this.row].length;
        }

        public String[][] toLines() {
            String[][] lines = new String[this.height][Data.this.columns.length];
            for (int lineNumber = 0; lineNumber < lines.length; ++lineNumber) {
                String[] columns = lines[lineNumber];
                for (int columnNumber = 0; columnNumber < columns.length; ++columnNumber) {
                    String content;
                    Cell cell = Data.this.cells[this.row][columnNumber];
                    columns[columnNumber] = content = lineNumber < cell.lines.size() ? (String)cell.lines.get(lineNumber) : "";
                }
            }
            return lines;
        }
    }
}

