/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest.table;

public class Line {
    private final String left;
    private final String right;
    private final String inner;
    private final String middle;

    public Line(String left, String right, String inner, String middle) {
        this.left = left;
        this.right = right;
        this.inner = inner;
        this.middle = middle;
    }

    public String getLeft() {
        return this.left;
    }

    public String getRight() {
        return this.right;
    }

    public String getMiddle() {
        return this.middle;
    }

    public String getInner() {
        return this.inner;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String left;
        private String right;
        private String inner;
        private String middle;

        private Builder() {
        }

        public Builder all(String string) {
            this.left = string;
            this.right = string;
            this.middle = string;
            this.inner = string;
            return this;
        }

        public Builder left(String left) {
            this.left = left;
            return this;
        }

        public Builder right(String right) {
            this.right = right;
            return this;
        }

        public Builder inner(String inner) {
            this.inner = inner;
            return this;
        }

        public Builder middle(String middle) {
            this.middle = middle;
            return this;
        }

        public Line build() {
            return new Line(this.left, this.right, this.inner, this.middle);
        }
    }
}

