/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest.table;

import java.util.stream.Stream;
import org.tomitribe.crest.help.Wrap;

public class Width {
    public static final Width ZERO = new Width(0, 0);
    private final int min;
    private final int max;

    public Width(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public Width toMin() {
        return new Width(this.min, this.min);
    }

    public Width toMax() {
        return new Width(this.max, this.max);
    }

    public static Width ofString(String string) {
        String wrapped = Wrap.wrap(string, 1);
        int maximum = string.length();
        int minimum = Stream.of(wrapped.split(System.lineSeparator())).map(String::length).reduce(Math::max).orElse(0);
        return new Width(minimum, maximum);
    }

    public Width adjust(Width that) {
        int min = Math.max(this.min, that.min);
        int max = Math.max(this.max, that.max);
        return new Width(min, max);
    }

    public Width add(Width that) {
        int min = this.min + that.min;
        int max = this.max + that.max;
        return new Width(min, max);
    }

    public Width subtract(Width that) {
        int min = this.min - that.min;
        int max = this.max - that.max;
        return new Width(min, max);
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public String toString() {
        return "Width{min=" + this.min + ", max=" + this.max + '}';
    }
}

