/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest.cmds.processors;

import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.tomitribe.crest.api.Command;
import org.tomitribe.crest.cmds.Cmd;
import org.tomitribe.crest.cmds.CmdGroup;
import org.tomitribe.crest.cmds.processors.Item;
import org.tomitribe.crest.cmds.processors.OptionParam;
import org.tomitribe.crest.environments.Environment;
import org.tomitribe.crest.help.CommandJavadoc;
import org.tomitribe.crest.help.Document;
import org.tomitribe.crest.help.DocumentParser;
import org.tomitribe.crest.help.Element;
import org.tomitribe.crest.help.Paragraph;
import org.tomitribe.crest.javadoc.Javadoc;
import org.tomitribe.crest.javadoc.JavadocParser;
import org.tomitribe.util.PrintString;
import org.tomitribe.util.reflect.Classes;

public class Help {
    private final Map<String, Cmd> commands;
    private final String version;
    private final String name;

    public Help(Map<String, Cmd> commands, String version, String name) {
        this.commands = commands;
        this.version = version;
        this.name = name;
    }

    public static void optionHelp(Method method, String commandName, Collection<OptionParam> optionParams, PrintStream out) {
        if (optionParams.isEmpty()) {
            return;
        }
        List<Item> items = Help.getItems(method, commandName, optionParams);
        int width = 20;
        for (Item item : items) {
            width = Math.max(width, item.getFlag().length());
        }
        String format = "  %-" + width + "s     %s%n";
        out.println("Options: ");
        for (Item item : items) {
            ArrayList<String> lines = new ArrayList<String>();
            if (item.getDescription() != null) {
                lines.add(item.getDescription());
            }
            lines.addAll(item.getNote());
            if (lines.isEmpty()) {
                lines.add("");
            }
            out.printf(format, item.getFlag(), lines.remove(0));
            for (String line : lines) {
                out.printf(format, "", String.format("(%s)", line));
            }
        }
        Help.printNameAndVersion(out);
    }

    public static void printNameAndVersion(PrintStream out) {
        Environment environment = Environment.get();
        String name = environment.getCommandName();
        String version = environment.getCommandVersion();
        if (version == null) {
            return;
        }
        if (name == null) {
            out.printf("%nVersion %s%n", version);
            return;
        }
        out.printf("%n%s %s%n", name, version);
    }

    public static List<Item> getItems(Method method, String commandName, Collection<OptionParam> optionParams) {
        CommandJavadoc commandJavadoc = CommandJavadoc.getCommandJavadocs(method, commandName);
        List<Item> items = Help.getItems(method, commandName, optionParams, commandJavadoc);
        return items.stream().map(Help::trimDescriptions).collect(Collectors.toList());
    }

    private static Item trimDescriptions(Item item) {
        if (item.getDescription() == null) {
            return item;
        }
        Document document = DocumentParser.parser(item.getDescription());
        if (document.getElements().size() == 0) {
            return item;
        }
        Element element = document.getElements().get(0);
        if (!(element instanceof Paragraph)) {
            return item;
        }
        String content = element.getContent();
        String[] sentences = content.split("\\. ");
        if (sentences.length == 0) {
            return item;
        }
        return new Item(item.getFlag(), sentences[0], item.getParam(), item.getNote());
    }

    public static List<Item> getItems(Method method, String commandName, Collection<OptionParam> optionParams, CommandJavadoc commandJavadoc) {
        Class<?> clazz = method.getDeclaringClass();
        List<Item> items = Help.getItems(clazz, commandName, optionParams);
        if (commandJavadoc == null || commandJavadoc.getJavadoc() == null) {
            return items;
        }
        Javadoc javadoc = JavadocParser.parse(commandJavadoc.getJavadoc());
        Map<String, Javadoc.Param> params = javadoc.getParametersByName();
        ListIterator<Item> iterator = items.listIterator();
        while (iterator.hasNext()) {
            Javadoc.Param param;
            Item item = iterator.next();
            if (item.getDescription() != null) continue;
            String optionName = item.getParam().getName();
            String javadocParameterName = commandJavadoc.getProperties().getProperty(optionName);
            if (javadocParameterName == null || (param = params.get(javadocParameterName)) == null || param.getDescription() == null) continue;
            Item updated = new Item(item.getFlag(), param.getDescription(), item.getParam(), item.getNote());
            iterator.set(updated);
        }
        return items;
    }

    public static List<Item> getItems(Class<?> clazz, String commandName, Collection<OptionParam> optionParams) {
        ResourceBundle general = null;
        ArrayList<Item> items = new ArrayList<Item>(optionParams.size());
        for (OptionParam optionParam : optionParams) {
            String description = optionParam.getDescription();
            if (description == null || description.isEmpty()) {
                if (general == null) {
                    general = Help.getResourceBundle(clazz);
                }
                description = Help.getDescription(general, commandName, optionParam.getName());
            }
            Item item = new Item(optionParam, description);
            items.add(item);
        }
        return items;
    }

    public static ResourceBundle getResourceBundle(Class<?> clazz) {
        try {
            return ResourceBundle.getBundle(Classes.packageName(clazz) + ".OptionDescriptions");
        }
        catch (MissingResourceException ok) {
            return null;
        }
    }

    public static String getDescription(ResourceBundle general, String commandName, String name) {
        if (general == null) {
            return null;
        }
        try {
            return general.getString(commandName + "." + name);
        }
        catch (MissingResourceException e) {
            try {
                return general.getString(name);
            }
            catch (MissingResourceException e1) {
                return null;
            }
        }
    }

    @Command
    public String help() {
        PrintString string = new PrintString();
        string.println("Commands: ");
        string.printf("   %-20s", new Object[]{""});
        string.println();
        TreeSet<String> strings = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                assert (null != s1);
                assert (null != s2);
                return s1.compareTo(s2);
            }
        });
        strings.addAll(this.commands.keySet());
        for (String command : strings) {
            string.printf("   %-20s%n", new Object[]{command});
        }
        Help.printNameAndVersion((PrintStream)string);
        return string.toString();
    }

    @Command
    public String help(String name) {
        Cmd cmd = this.commands.get(name);
        if (cmd == null) {
            return String.format("No such command: %s%n", name);
        }
        PrintString out = new PrintString();
        cmd.manual((PrintStream)out);
        return out.toString();
    }

    @Command
    public String help(String name, String subCommand) {
        Cmd cmd = this.commands.get(name);
        if (cmd == null) {
            return String.format("No such command: %s%n", name);
        }
        PrintString out = new PrintString();
        if (cmd instanceof CmdGroup) {
            CmdGroup cmdGroup = (CmdGroup)cmd;
            cmdGroup.manual(subCommand, (PrintStream)out);
        } else {
            cmd.manual((PrintStream)out);
        }
        return out.toString();
    }
}

