/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest.environments;

import java.io.InputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.tomitribe.crest.environments.Environment;
import org.tomitribe.crest.val.BeanValidation;
import org.tomitribe.crest.val.BeanValidationImpl;

public class SystemEnvironment
implements Environment {
    private final Map<Class<?>, Object> services;
    private final PrintStream out;
    private final PrintStream err;
    private final InputStream in;
    private final Properties properties;
    private final String name;
    private final String version;

    public SystemEnvironment(Map<Class<?>, Object> services) {
        this(services, System.out, System.err, System.in, System.getProperties(), null, null);
    }

    protected SystemEnvironment(Map<Class<?>, Object> services, PrintStream out, PrintStream err, InputStream in, Properties properties, String name, String version) {
        this.services = new HashMap(services);
        this.out = out;
        this.err = err;
        this.in = in;
        this.properties = properties;
        this.name = name;
        this.version = version;
        this.init();
    }

    public SystemEnvironment() {
        this(new HashMap());
    }

    @Override
    public String getCommandName() {
        return this.name;
    }

    @Override
    public String getCommandVersion() {
        return this.version;
    }

    @Override
    public PrintStream getOutput() {
        return this.out;
    }

    @Override
    public PrintStream getError() {
        return this.err;
    }

    @Override
    public InputStream getInput() {
        return this.in;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public <T> T findService(Class<T> type) {
        return type.cast(this.services.get(type));
    }

    protected void init() {
        this.services.put(BeanValidationImpl.class, BeanValidation.create(this::findService));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private String version;
        private Map<Class<?>, Object> services = new HashMap();
        private PrintStream out;
        private PrintStream err;
        private InputStream in;
        private Properties properties;

        private Builder() {
        }

        public Builder services(Map<Class<?>, Object> services) {
            this.services = services;
            return this;
        }

        public Builder service(Class<?> type, Object service) {
            this.services.put(type, service);
            return this;
        }

        public Builder out(PrintStream out) {
            this.out = out;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder err(PrintStream err) {
            this.err = err;
            return this;
        }

        public Builder in(InputStream in) {
            this.in = in;
            return this;
        }

        public Builder properties(Properties properties) {
            this.properties = properties;
            return this;
        }

        public SystemEnvironment build() {
            return new SystemEnvironment(this.services, this.out, this.err, this.in, this.properties, this.name, this.version);
        }
    }
}

