/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.crest.val;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.stream.Stream;
import org.tomitribe.crest.api.validation.Validation;
import org.tomitribe.crest.val.BeanValidationImpl;

public class BuiltInValidation
implements BeanValidationImpl {
    private final BeanValidationImpl sibling;
    private final Map<Executable, Consumer<Object[]>> validatorPerExecutable = new ConcurrentHashMap<Executable, Consumer<Object[]>>();
    private final Function<Class<?>, Object> lookup;

    public BuiltInValidation(BeanValidationImpl sibling, Function<Class<?>, Object> lookup) {
        this.sibling = sibling;
        this.lookup = lookup;
    }

    @Override
    public void validateParameters(Object instanceOrClass, Method method, Object[] parameters) {
        this.doValidateParameters(method, parameters);
        if (this.sibling != null) {
            this.sibling.validateParameters(instanceOrClass, method, parameters);
        }
    }

    @Override
    public void validateParameters(Constructor constructor, Object[] parameters) {
        this.doValidateParameters(constructor, parameters);
        if (this.sibling != null) {
            this.sibling.validateParameters(constructor, parameters);
        }
    }

    @Override
    public Optional<List<String>> messages(Throwable exception) {
        return Optional.of(exception).filter(ValidationMessages.class::isInstance).map(ValidationMessages.class::cast).map(e -> ((ValidationMessages)e).messages);
    }

    private Object createInstance(Class<?> value) {
        return Optional.ofNullable(this.lookup.apply(value)).orElseGet(() -> {
            try {
                return value.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
                throw new IllegalArgumentException(e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException(e.getTargetException());
            }
        });
    }

    private void doValidateParameters(Executable executable, Object[] parameters) {
        this.validatorPerExecutable.computeIfAbsent(executable, e -> {
            if (executable.getParameterCount() == 0) {
                return a -> {};
            }
            Consumer[] validators = (Consumer[])Stream.of(executable.getParameters()).map(this::toValidator).toArray(Consumer[]::new);
            return args -> this.executeValidations(validators.length, i -> validators[i].accept(args[i]));
        }).accept(parameters);
    }

    private Consumer<Object> toValidator(Parameter parameter) {
        Consumer[] validations = (Consumer[])Stream.of(parameter.getAnnotations()).filter(it -> it.annotationType().isAnnotationPresent(Validation.class)).map(it -> {
            Class value = it.annotationType().getAnnotation(Validation.class).value();
            Object validationInstance = this.createInstance(value);
            if (Consumer.class.isInstance(validationInstance)) {
                return (Consumer)Consumer.class.cast(validationInstance);
            }
            if (BiConsumer.class.isInstance(validationInstance)) {
                BiConsumer biConsumer = (BiConsumer)BiConsumer.class.cast(validationInstance);
                return a -> biConsumer.accept(it, a);
            }
            throw new IllegalArgumentException("Invalid validation, expected Consumer or BiConsumer but got " + value);
        }).toArray(Consumer[]::new);
        if (validations.length == 0) {
            return a -> {};
        }
        return a -> this.executeValidations(validations.length, i -> validations[i].accept(a));
    }

    private <T> void executeValidations(int max, IntConsumer validate) {
        ValidationMessages exception = null;
        for (int i = 0; i < max; ++i) {
            try {
                validate.accept(i);
                continue;
            }
            catch (RuntimeException re) {
                if (exception == null) {
                    exception = new ValidationMessages(new ArrayList());
                }
                if (ValidationMessages.class.isInstance(re)) {
                    exception.messages.addAll(((ValidationMessages)ValidationMessages.class.cast(re)).messages);
                    continue;
                }
                exception.messages.add(re.getMessage());
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    private static class ValidationMessages
    extends RuntimeException {
        private final List<String> messages;

        private ValidationMessages(List<String> messages) {
            super(String.join((CharSequence)", ", messages));
            this.messages = messages;
        }
    }
}

