/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.util.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.tomitribe.util.reflect.Parameter;

public class Generics {
    private Generics() {
    }

    public static Type getType(Field field) {
        return Generics.getTypeParameters(field.getType(), field.getGenericType())[0];
    }

    public static Type getType(Parameter parameter) {
        return Generics.getTypeParameters(parameter.getType(), parameter.getGenericType())[0];
    }

    public static Type getReturnType(Method method) {
        return Generics.getTypeParameters(method.getReturnType(), method.getGenericReturnType())[0];
    }

    public static Type[] getTypeParameters(Class genericClass, Type type) {
        if (type instanceof Class) {
            Class rawClass = (Class)type;
            if (genericClass.equals(type)) {
                return null;
            }
            for (Type intf : rawClass.getGenericInterfaces()) {
                Type[] collectionType = Generics.getTypeParameters(genericClass, intf);
                if (collectionType == null) continue;
                return collectionType;
            }
            Type[] collectionType = Generics.getTypeParameters(genericClass, rawClass.getGenericSuperclass());
            return collectionType;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            if (genericClass.equals(rawType)) {
                Type[] argument = parameterizedType.getActualTypeArguments();
                return argument;
            }
            Type[] collectionTypes = Generics.getTypeParameters(genericClass, rawType);
            if (collectionTypes != null) {
                for (int i = 0; i < collectionTypes.length; ++i) {
                    if (!(collectionTypes[i] instanceof TypeVariable)) continue;
                    TypeVariable typeVariable = (TypeVariable)collectionTypes[i];
                    TypeVariable<Class<T>>[] rawTypeParams = ((Class)rawType).getTypeParameters();
                    for (int j = 0; j < rawTypeParams.length; ++j) {
                        if (!typeVariable.getName().equals(rawTypeParams[j].getName())) continue;
                        collectionTypes[i] = parameterizedType.getActualTypeArguments()[j];
                    }
                }
            }
            return collectionTypes;
        }
        return null;
    }
}

