/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.util.collect;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class CompositeIterator<T>
implements Iterator<T> {
    private final Iterator<Iterator<T>> source;
    private Iterator<T> current;

    private CompositeIterator(Iterator<Iterator<T>> source) {
        this.source = source;
        if (this.source.hasNext()) {
            this.current = this.source.next();
        }
    }

    @Override
    public boolean hasNext() {
        if (this.current == null) {
            return false;
        }
        if (this.current.hasNext()) {
            return true;
        }
        if (this.source.hasNext()) {
            this.current = this.source.next();
            return this.hasNext();
        }
        return false;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.current.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

