/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.util.hash;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.tomitribe.util.IO;
import org.tomitribe.util.hash.Preconditions;
import org.tomitribe.util.hash.Slice;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

public final class Slices {
    public static final Slice EMPTY_SLICE = new Slice();
    private static final int SLICE_ALLOC_THRESHOLD = 524288;
    private static final double SLICE_ALLOW_SKEW = 1.25;

    private Slices() {
    }

    public static Slice ensureSize(Slice existingSlice, int minWritableBytes) {
        if (existingSlice == null) {
            return Slices.allocate(minWritableBytes);
        }
        if (minWritableBytes <= existingSlice.length()) {
            return existingSlice;
        }
        int newCapacity = existingSlice.length() == 0 ? 1 : existingSlice.length();
        int minNewCapacity = existingSlice.length() + minWritableBytes;
        while (newCapacity < minNewCapacity) {
            if (newCapacity < 524288) {
                newCapacity <<= 1;
                continue;
            }
            newCapacity = (int)((double)newCapacity * 1.25);
        }
        Slice newSlice = Slices.allocate(newCapacity);
        newSlice.setBytes(0, existingSlice, 0, existingSlice.length());
        return newSlice;
    }

    public static Slice allocate(int capacity) {
        if (capacity == 0) {
            return EMPTY_SLICE;
        }
        return new Slice(new byte[capacity]);
    }

    public static Slice allocateDirect(int capacity) {
        if (capacity == 0) {
            return EMPTY_SLICE;
        }
        return Slices.wrappedBuffer(ByteBuffer.allocateDirect(capacity));
    }

    public static Slice copyOf(Slice slice) {
        return Slices.copyOf(slice, 0, slice.length());
    }

    public static Slice copyOf(Slice slice, int offset, int length) {
        Preconditions.checkPositionIndexes(offset, offset + length, slice.length());
        Slice copy = Slices.allocate(length);
        copy.setBytes(0, slice, offset, length);
        return copy;
    }

    public static Slice wrappedBuffer(ByteBuffer buffer) {
        if (buffer instanceof DirectBuffer) {
            DirectBuffer direct = (DirectBuffer)((Object)buffer);
            return new Slice(null, direct.address(), buffer.capacity(), direct);
        }
        if (buffer.hasArray()) {
            int address = Unsafe.ARRAY_BYTE_BASE_OFFSET + buffer.arrayOffset();
            return new Slice(buffer.array(), address, buffer.capacity(), null);
        }
        throw new IllegalArgumentException("cannot wrap " + buffer.getClass().getName());
    }

    public static Slice wrappedBuffer(byte[] array) {
        if (array.length == 0) {
            return EMPTY_SLICE;
        }
        return new Slice(array);
    }

    public static Slice wrappedBuffer(byte[] array, int offset, int length) {
        if (length == 0) {
            return EMPTY_SLICE;
        }
        return new Slice(array, offset, length);
    }

    public static Slice wrappedBooleanArray(boolean ... array) {
        return Slices.wrappedBooleanArray(array, 0, array.length);
    }

    public static Slice wrappedBooleanArray(boolean[] array, int offset, int length) {
        if (length == 0) {
            return EMPTY_SLICE;
        }
        return new Slice(array, offset, length);
    }

    public static Slice wrappedShortArray(short ... array) {
        return Slices.wrappedShortArray(array, 0, array.length);
    }

    public static Slice wrappedShortArray(short[] array, int offset, int length) {
        if (length == 0) {
            return EMPTY_SLICE;
        }
        return new Slice(array, offset, length);
    }

    public static Slice wrappedIntArray(int ... array) {
        return Slices.wrappedIntArray(array, 0, array.length);
    }

    public static Slice wrappedIntArray(int[] array, int offset, int length) {
        if (length == 0) {
            return EMPTY_SLICE;
        }
        return new Slice(array, offset, length);
    }

    public static Slice wrappedLongArray(long ... array) {
        return Slices.wrappedLongArray(array, 0, array.length);
    }

    public static Slice wrappedLongArray(long[] array, int offset, int length) {
        if (length == 0) {
            return EMPTY_SLICE;
        }
        return new Slice(array, offset, length);
    }

    public static Slice wrappedFloatArray(float ... array) {
        return Slices.wrappedFloatArray(array, 0, array.length);
    }

    public static Slice wrappedFloatArray(float[] array, int offset, int length) {
        if (length == 0) {
            return EMPTY_SLICE;
        }
        return new Slice(array, offset, length);
    }

    public static Slice wrappedDoubleArray(double ... array) {
        return Slices.wrappedDoubleArray(array, 0, array.length);
    }

    public static Slice wrappedDoubleArray(double[] array, int offset, int length) {
        if (length == 0) {
            return EMPTY_SLICE;
        }
        return new Slice(array, offset, length);
    }

    public static Slice copiedBuffer(String string, Charset charset) {
        Preconditions.checkNotNull(string, "string is null");
        Preconditions.checkNotNull(charset, "charset is null");
        return Slices.wrappedBuffer(string.getBytes(charset));
    }

    public static Slice utf8Slice(String string) {
        return Slices.copiedBuffer(string, StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Slice mapFileReadOnly(File file) throws IOException {
        Preconditions.checkNotNull(file, "file is null");
        if (!file.exists()) {
            throw new FileNotFoundException(file.toString());
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        FileChannel channel = randomAccessFile.getChannel();
        try {
            MappedByteBuffer byteBuffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
            Slice slice = Slices.wrappedBuffer(byteBuffer);
            return slice;
        }
        finally {
            IO.close(randomAccessFile);
            IO.close(channel);
        }
    }
}

