/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.util.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;

public class Parameter
implements AnnotatedElement {
    private final Annotation[] annotations;
    private final Class<?> type;
    private final Type genericType;

    public Parameter(Annotation[] annotations, Class<?> type, Type genericType) {
        this.annotations = annotations;
        this.type = type;
        this.genericType = genericType;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Type getGenericType() {
        return this.genericType;
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.getAnnotation(annotationClass) != null;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        for (Annotation annotation : this.annotations) {
            if (!annotationClass.equals(annotation.annotationType())) continue;
            return (T)annotation;
        }
        return null;
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.getAnnotations();
    }
}

