/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.tomitribe.util.Files;
import org.tomitribe.util.IO;

public class Zips {
    private Zips() {
    }

    public static void unzip(File zipFile, File destination) throws IOException {
        Zips.unzip(zipFile, destination, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File zipFile, File destination, boolean noparent) throws IOException {
        Files.dir(destination);
        Files.writable(destination);
        Files.file(zipFile);
        Files.readable(zipFile);
        InputStream read = IO.read(zipFile);
        try {
            Zips.unzip(read, destination, noparent);
        }
        finally {
            IO.close(read);
        }
    }

    public static void unzip(InputStream read, File destination, boolean noparent) throws IOException {
        try {
            ZipEntry entry;
            ZipInputStream e = new ZipInputStream(read);
            while ((entry = e.getNextEntry()) != null) {
                String path = entry.getName();
                if (noparent) {
                    path = path.replaceFirst("^[^/]+/", "");
                }
                File file = new File(destination, path);
                if (entry.isDirectory()) {
                    Files.mkdir(file);
                    continue;
                }
                Files.mkdir(file.getParentFile());
                IO.copy((InputStream)e, file);
                long lastModified = entry.getTime();
                if (lastModified <= 0L) continue;
                file.setLastModified(lastModified);
            }
            e.close();
        }
        catch (IOException var9) {
            throw new IOException("Unable to unzip " + read, var9);
        }
    }
}

