/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.util.reflect;

import java.util.Arrays;
import java.util.Iterator;

public class StackTraceElements {
    private StackTraceElements() {
    }

    public static StackTraceElement getCurrentMethod() {
        Iterator<StackTraceElement> stackTrace = StackTraceElements.seek(StackTraceElements.class, "getCurrentMethod");
        return stackTrace.next();
    }

    public static StackTraceElement getCallingMethod() {
        Iterator<StackTraceElement> stackTrace = StackTraceElements.seek(StackTraceElements.class, "getCallingMethod");
        stackTrace.next();
        return stackTrace.next();
    }

    private static Iterator<StackTraceElement> seek(Class<StackTraceElements> clazz, String method) {
        StackTraceElement next;
        Iterator<StackTraceElement> stackTrace = Arrays.asList(new Exception().fillInStackTrace().getStackTrace()).iterator();
        while (!(!stackTrace.hasNext() || (next = stackTrace.next()).getClassName().equals(clazz.getName()) && next.getMethodName().equals(method))) {
        }
        return stackTrace;
    }

    public static Class<?> asClass(StackTraceElement stackTraceElement) throws ClassNotFoundException {
        return StackTraceElements.asClass(stackTraceElement, Thread.currentThread().getContextClassLoader());
    }

    public static Class<?> asClass(StackTraceElement stackTraceElement, ClassLoader classLoader) throws ClassNotFoundException {
        return classLoader.loadClass(stackTraceElement.getClassName());
    }
}

