/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import org.tomitribe.util.collect.AbstractIterator;
import org.tomitribe.util.collect.FilteredIterator;

public class Files {
    private static final DeleteOnExit DELETE_ON_EXIT = new DeleteOnExit();
    public static final FileFilter ALL = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return true;
        }
    };

    private Files() {
    }

    public static File file(String ... parts) {
        File dir = null;
        for (String part : parts) {
            dir = dir == null ? new File(part) : new File(dir, part);
        }
        return dir;
    }

    public static File file(File dir, String ... parts) {
        for (String part : parts) {
            dir = new File(dir, part);
        }
        return dir;
    }

    public static List<File> collect(File dir) {
        return Files.collect(dir, ALL);
    }

    public static List<File> collect(File dir, String regex) {
        return Files.collect(dir, Pattern.compile(regex));
    }

    public static List<File> collect(File dir, Pattern pattern) {
        return Files.collect(dir, new PatternFileFilter(pattern));
    }

    public static boolean visit(File dir, Visitor visitor) {
        return Files.visit(dir, ALL, visitor);
    }

    public static boolean visit(File dir, String regex, Visitor visitor) {
        return Files.visit(dir, Pattern.compile(regex), visitor);
    }

    public static boolean visit(File dir, Pattern pattern, final Visitor visitor) {
        final PatternFileFilter patternFileFilter = new PatternFileFilter(pattern);
        return Files.visit(dir, new FileFilter(){

            @Override
            public boolean accept(File file) {
                return true;
            }
        }, new Visitor(){

            @Override
            public boolean visit(File file) {
                if (file.isFile() && patternFileFilter.accept(file)) {
                    visitor.visit(file);
                }
                return true;
            }
        });
    }

    public static Iterable<File> iterate(File dir) {
        return Files.iterate(dir, ALL);
    }

    public static Iterable<File> iterate(File dir, String regex) {
        return Files.iterate(dir, Pattern.compile(regex));
    }

    public static Iterable<File> iterate(File dir, Pattern pattern) {
        return Files.iterate(dir, new PatternFileFilter(pattern));
    }

    public static List<File> collect(File dir, FileFilter filter) {
        ArrayList<File> accepted = new ArrayList<File>();
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (filter.accept(file)) {
                    accepted.add(file);
                }
                accepted.addAll(Files.collect(file, filter));
            }
        }
        return accepted;
    }

    public static Iterable<File> iterate(final File dir, final FileFilter filter) {
        return new Iterable<File>(){

            @Override
            public Iterator<File> iterator() {
                return new FilteredIterator<File>(new RecursiveFileIterator(dir), new FilteredIterator.Filter<File>(){

                    @Override
                    public boolean accept(File file) {
                        return filter.accept(file);
                    }
                });
            }
        };
    }

    public static boolean visit(File dir, FileFilter filter, Visitor visitor) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!filter.accept(file)) {
                    return false;
                }
                if (!visitor.visit(file)) {
                    return false;
                }
                if (Files.visit(file, filter, visitor)) continue;
                return false;
            }
        }
        return true;
    }

    public static void exists(File file, String s) {
        if (!file.exists()) {
            throw new IllegalStateException(s + " does not exist: " + file.getAbsolutePath());
        }
    }

    public static void exists(File file) {
        Files.exists(file, "File");
    }

    public static void dir(File file) {
        if (!file.isDirectory()) {
            throw new IllegalStateException("Not a directory: " + file.getAbsolutePath());
        }
    }

    public static void file(File file) {
        if (!file.isFile()) {
            throw new IllegalStateException("Not a file: " + file.getAbsolutePath());
        }
    }

    public static void writable(File file) {
        if (!file.canWrite()) {
            throw new IllegalStateException("Not writable: " + file.getAbsolutePath());
        }
    }

    public static void readable(File file) {
        if (!file.canRead()) {
            throw new IllegalStateException("Not readable: " + file.getAbsolutePath());
        }
    }

    public static File rename(File from, File to) {
        if (!from.renameTo(to)) {
            throw new IllegalStateException("Could not rename " + from.getAbsolutePath() + " to " + to.getAbsolutePath());
        }
        return to;
    }

    public static void remove(File file) {
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            Files.delete(file);
        } else if (!file.delete()) {
            throw new IllegalStateException("Could not delete file: " + file.getAbsolutePath());
        }
    }

    private static void delete(File file) {
        SimpleFileVisitor<Path> visitor = new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                java.nio.file.Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                java.nio.file.Files.delete(file);
                return FileVisitResult.CONTINUE;
            }
        };
        try {
            java.nio.file.Files.walkFileTree(file.toPath(), (FileVisitor<? super Path>)visitor);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not delete directory: " + file.getAbsolutePath(), e);
        }
    }

    public static void mkdir(File file) {
        if (file.exists()) {
            Files.dir(file);
            return;
        }
        if (!file.mkdir()) {
            throw new RuntimeException("Cannot mkdir: " + file.getAbsolutePath());
        }
    }

    public static File tmpdir() {
        return Files.tmpdir(true);
    }

    public static File tmpdir(boolean deleteOnExit) {
        try {
            File file = File.createTempFile("temp", "dir");
            if (!file.delete()) {
                throw new IllegalStateException("Cannot make temp dir.  Delete failed");
            }
            Files.mkdir(file);
            if (deleteOnExit) {
                DELETE_ON_EXIT.clean(file);
            }
            return file;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void mkparent(File file) {
        Files.mkdirs(file.getParentFile(), new String[0]);
    }

    public static File mkparent(File dir, String ... parts) {
        File file = Files.file(dir, parts);
        Files.mkparent(file);
        return file;
    }

    public static File mkdirs(File dir, String ... parts) {
        File file = Files.file(dir, parts);
        if (!file.exists()) {
            if (!file.mkdirs()) {
                throw new RuntimeException("Cannot mkdirs: " + file.getAbsolutePath());
            }
        } else {
            Files.dir(file);
        }
        return file;
    }

    public static File resolve(File absolutePath, File path) {
        if (path == null) {
            throw new IllegalArgumentException("path is null");
        }
        if (path.isAbsolute()) {
            return path;
        }
        if (absolutePath == null) {
            throw new IllegalArgumentException("absolutePath is null");
        }
        Files.absolute(absolutePath);
        return new File(absolutePath, path.getPath());
    }

    public static void absolute(File path) {
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException("absolutePath is not absolute: " + path.getPath());
        }
    }

    public static String format(double size) {
        double d;
        double d2;
        double d3;
        double d4;
        if (size < 1024.0) {
            return String.format("%.0f B", size);
        }
        size /= 1024.0;
        if (d4 < 1024.0) {
            return String.format("%.0f KB", size);
        }
        size /= 1024.0;
        if (d3 < 1024.0) {
            return String.format("%.0f MB", size);
        }
        size /= 1024.0;
        if (d2 < 1024.0) {
            return String.format("%.1f GB", size);
        }
        size /= 1024.0;
        if (d < 1024.0) {
            return String.format("%.1f TB", size);
        }
        return "unknown";
    }

    public static class DeleteOnExit {
        private final List<File> files = new ArrayList<File>();

        public DeleteOnExit() {
            Runtime.getRuntime().addShutdownHook(new Thread(this::clean));
        }

        public File clean(File file) {
            this.files.add(file);
            return file;
        }

        public void clean() {
            this.files.stream().forEach(this::delete);
        }

        private void delete(File file) {
            try {
                java.nio.file.Files.walkFileTree(file.toPath(), new RecursiveDelete());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private static class RecursiveDelete
        implements FileVisitor<Path> {
            private RecursiveDelete() {
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                java.nio.file.Files.deleteIfExists(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                java.nio.file.Files.deleteIfExists(dir);
                return FileVisitResult.CONTINUE;
            }
        }
    }

    private static class PatternFileFilter
    implements FileFilter {
        private final Pattern pattern;

        public PatternFileFilter(Pattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean accept(File file) {
            return this.pattern.matcher(file.getAbsolutePath()).matches();
        }
    }

    private static class RecursiveFileIterator
    extends AbstractIterator<File> {
        private final LinkedList<FileIterator> stack = new LinkedList();

        public RecursiveFileIterator(File base) {
            this.stack.add(new FileIterator(base));
        }

        @Override
        protected File advance() throws NoSuchElementException {
            FileIterator current = this.stack.element();
            try {
                File file = current.advance();
                if (file == null) {
                    this.stack.pop();
                    return this.advance();
                }
                if (file.isDirectory()) {
                    this.stack.push(new FileIterator(file));
                }
                return file;
            }
            catch (NoSuchElementException e) {
                this.stack.pop();
                return this.advance();
            }
        }
    }

    private static class FileIterator
    extends AbstractIterator<File> {
        private final File[] files;
        private int index;

        private FileIterator(File dir) {
            Files.dir(dir);
            this.files = dir.listFiles();
            this.index = 0;
        }

        @Override
        protected File advance() throws NoSuchElementException {
            if (this.index >= this.files.length) {
                return null;
            }
            return this.files[this.index++];
        }
    }

    public static interface Visitor {
        public boolean visit(File var1);
    }
}

