/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.util;

import org.tomitribe.util.Hex;

public class Ints {
    private Ints() {
    }

    public static byte[] toBytes(int v) {
        byte[] bytes = new byte[]{(byte)(v >>> 24), (byte)(v >>> 16), (byte)(v >>> 8), (byte)v};
        return bytes;
    }

    public static int fromBytes(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes are null");
        }
        if (bytes.length != 4) {
            throw new IllegalArgumentException("bytes length not 4: " + bytes.length);
        }
        return (bytes[0] << 24) + ((bytes[1] & 0xFF) << 16) + ((bytes[2] & 0xFF) << 8) + (bytes[3] & 0xFF);
    }

    public static String toHex(int value) {
        byte[] bytes = Ints.toBytes(value);
        return Hex.toString(bytes);
    }

    public static int fromHex(String hex) {
        byte[] bytes = Hex.fromString(hex);
        return Ints.fromBytes(bytes);
    }
}

