/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.tomitribe.util.Futures;

public final class Pipe
implements Runnable {
    private final InputStream in;
    private final OutputStream out;

    public Pipe(InputStream in, OutputStream out) {
        this.in = in;
        this.out = out;
    }

    public static Future<List<Pipe>> pipe(Process process) {
        return Futures.of(Pipe.pipe(process.getInputStream(), System.out), Pipe.pipe(process.getErrorStream(), System.err));
    }

    public static Future<Pipe> pipe(InputStream in, OutputStream out) {
        Pipe target = new Pipe(in, out);
        FutureTask<Pipe> task = new FutureTask<Pipe>(target, target);
        Thread thread = new Thread(task);
        thread.setDaemon(true);
        thread.start();
        return task;
    }

    @Override
    public void run() {
        try {
            int i = -1;
            byte[] buf = new byte[1024];
            while ((i = this.in.read(buf)) != -1) {
                this.out.write(buf, 0, i);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

