/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.util;

import java.util.ArrayList;
import java.util.Arrays;

public class Version
implements Comparable<Version> {
    private final String version;
    private final int[] components;

    public Version(String version, int ... components) {
        this.version = version;
        this.components = components;
    }

    public String getVersion() {
        return this.version;
    }

    public int[] getComponents() {
        return this.components;
    }

    @Override
    public int compareTo(Version that) {
        for (int i = 0; i < this.components.length; ++i) {
            if (that.components.length <= i) {
                return 1;
            }
            int componentA = this.components[i];
            int componentB = that.components[i];
            int compare = Integer.compare(componentA, componentB);
            if (compare == 0) continue;
            return compare;
        }
        return 0;
    }

    public static Version parse(String versionOutput) {
        if (versionOutput == null) {
            return null;
        }
        if (versionOutput.trim().length() == 0) {
            return new Version(versionOutput, new int[0]);
        }
        String input = versionOutput.replaceAll("^[.+_ a-zA-Z-]+", "").replaceAll("[.+_ a-zA-Z-]+$", "");
        String[] split = input.split("[.+_ a-zA-Z-]+");
        ArrayList<Integer> componentList = new ArrayList<Integer>();
        for (int i = 0; i < split.length; ++i) {
            try {
                componentList.add(Integer.parseInt(split[i]));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        int[] components = new int[componentList.size()];
        for (int i = 0; i < componentList.size(); ++i) {
            components[i] = (Integer)componentList.get(i);
        }
        return new Version(versionOutput, components);
    }

    public static String[] sort(String[] versions) {
        return (String[])Arrays.stream(versions).map(Version::parse).sorted().map(Version::getVersion).toArray(String[]::new);
    }

    public String toString() {
        return "Version{version='" + this.version + '\'' + ", components=" + Arrays.toString(this.components) + '}';
    }
}

