/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.util.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Objects;
import java.util.stream.Stream;
import org.tomitribe.util.reflect.Parameter;

public class Generics {
    private Generics() {
    }

    public static Type getType(Field field) {
        return Generics.getTypeParameters(field.getType(), field.getGenericType())[0];
    }

    public static Type getType(Parameter parameter) {
        return Generics.getTypeParameters(parameter.getType(), parameter.getGenericType())[0];
    }

    public static Type getReturnType(Method method) {
        return Generics.getTypeParameters(method.getReturnType(), method.getGenericReturnType())[0];
    }

    public static Type[] getInterfaceTypes(Class<?> intrface, Class<?> clazz) {
        if (!intrface.isAssignableFrom(clazz)) {
            return null;
        }
        Type[] types = Generics.genericTypes(clazz).filter(type -> type instanceof ParameterizedType).map(ParameterizedType.class::cast).filter(parameterizedType -> intrface.equals(parameterizedType.getRawType())).map(ParameterizedType::getActualTypeArguments).findFirst();
        if (types.isPresent()) {
            return types.get();
        }
        types = Generics.declaredTypes(clazz).filter(Objects::nonNull).map(aClass -> Generics.getInterfaceTypes(intrface, aClass)).filter(Objects::nonNull).findFirst().orElse(null);
        if (types == null) {
            return null;
        }
        for (int i = 0; i < types.length; ++i) {
            types[i] = Generics.resolveTypeVariable(types[i], clazz);
            types[i] = Generics.resolveParameterizedTypes(types[i], clazz);
        }
        return types;
    }

    private static Type resolveParameterizedTypes(Type parameterized, Class<?> clazz) {
        if (!(parameterized instanceof ParameterizedType)) {
            return parameterized;
        }
        ParameterizedType parameterizedType = (ParameterizedType)parameterized;
        Type[] types = parameterizedType.getActualTypeArguments();
        boolean modified = false;
        for (int i = 0; i < types.length; ++i) {
            Type original = types[i];
            types[i] = Generics.resolveTypeVariable(types[i], clazz);
            types[i] = Generics.resolveParameterizedTypes(types[i], clazz);
            if (original.equals(types[i])) continue;
            modified = true;
        }
        if (!modified) {
            return parameterized;
        }
        return new ResolvedParameterizedType(parameterizedType, types);
    }

    private static Type resolveTypeVariable(Type variable, Class<?> clazz) {
        if (!(variable instanceof TypeVariable)) {
            return variable;
        }
        TypeVariable typeVariable = (TypeVariable)variable;
        Object genericDeclaration = typeVariable.getGenericDeclaration();
        if (!(genericDeclaration instanceof Class)) {
            return variable;
        }
        Class declaringClass = (Class)genericDeclaration;
        int typePosition = Generics.positionOf(variable, declaringClass.getTypeParameters());
        if (typePosition == -1) {
            return variable;
        }
        Type[] actualTypes = Generics.genericTypes(clazz).filter(type -> type instanceof ParameterizedType).map(ParameterizedType.class::cast).filter(parameterizedType -> declaringClass.equals(parameterizedType.getRawType())).map(ParameterizedType::getActualTypeArguments).findFirst().orElse(null);
        if (actualTypes == null) {
            return variable;
        }
        if (actualTypes.length != declaringClass.getTypeParameters().length) {
            return variable;
        }
        Type resolvedType = actualTypes[typePosition];
        return resolvedType;
    }

    private static Stream<Type> genericTypes(Class<?> clazz) {
        return Stream.concat(Stream.of(clazz.getGenericSuperclass()), Stream.of(clazz.getGenericInterfaces()));
    }

    private static Stream<Class<?>> declaredTypes(Class<?> clazz) {
        return Stream.concat(Stream.of(clazz.getSuperclass()), Stream.of(clazz.getInterfaces()));
    }

    private static int positionOf(Type variable, TypeVariable<? extends Class<?>>[] typeParameters) {
        for (int i = 0; i < typeParameters.length; ++i) {
            TypeVariable<Class<?>> typeParameter = typeParameters[i];
            if (!variable.equals(typeParameter)) continue;
            return i;
        }
        return -1;
    }

    public static Type[] getTypeParameters(Class genericClass, Type type) {
        if (type instanceof Class) {
            Class rawClass = (Class)type;
            if (genericClass.equals(type)) {
                return null;
            }
            for (Type intf : rawClass.getGenericInterfaces()) {
                Type[] collectionType = Generics.getTypeParameters(genericClass, intf);
                if (collectionType == null) continue;
                return collectionType;
            }
            Type[] collectionType = Generics.getTypeParameters(genericClass, rawClass.getGenericSuperclass());
            return collectionType;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            if (genericClass.equals(rawType)) {
                Type[] argument = parameterizedType.getActualTypeArguments();
                return argument;
            }
            Type[] collectionTypes = Generics.getTypeParameters(genericClass, rawType);
            if (collectionTypes != null) {
                for (int i = 0; i < collectionTypes.length; ++i) {
                    if (!(collectionTypes[i] instanceof TypeVariable)) continue;
                    TypeVariable typeVariable = (TypeVariable)collectionTypes[i];
                    TypeVariable<Class<T>>[] rawTypeParams = ((Class)rawType).getTypeParameters();
                    for (int j = 0; j < rawTypeParams.length; ++j) {
                        if (!typeVariable.getName().equals(rawTypeParams[j].getName())) continue;
                        collectionTypes[i] = parameterizedType.getActualTypeArguments()[j];
                    }
                }
            }
            return collectionTypes;
        }
        return null;
    }

    private static class ResolvedParameterizedType
    implements ParameterizedType {
        private final ParameterizedType parameterizedType;
        private final Type[] actualTypesResolved;

        public ResolvedParameterizedType(ParameterizedType parameterizedType, Type[] actualTypes) {
            this.parameterizedType = parameterizedType;
            this.actualTypesResolved = actualTypes;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return this.actualTypesResolved;
        }

        @Override
        public Type getRawType() {
            return this.parameterizedType.getRawType();
        }

        @Override
        public Type getOwnerType() {
            return this.parameterizedType.getOwnerType();
        }

        @Override
        public String getTypeName() {
            return this.parameterizedType.getTypeName();
        }
    }
}

