/*
 * Decompiled with CFR 0.152.
 */
package org.torquebox.mojo.rubygems;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Sha1Digest {
    private final MessageDigest digest;

    public Sha1Digest() {
        try {
            this.digest = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("no SHA1 digest on system");
        }
    }

    public void update(byte b) {
        this.digest.update(b);
    }

    public void update(byte[] bytes) {
        this.digest.update(bytes);
    }

    public String hexDigest() {
        StringBuilder dig = new StringBuilder();
        for (byte b : this.digest.digest()) {
            if (b < 0) {
                dig.append(Integer.toHexString(256 + b));
                continue;
            }
            if (b < 16) {
                dig.append("0").append(Integer.toHexString(b));
                continue;
            }
            dig.append(Integer.toHexString(b));
        }
        return dig.toString();
    }
}

