/*
 * Decompiled with CFR 0.152.
 */
package org.unix4j.command;

import org.unix4j.io.FileInput;
import org.unix4j.io.Input;

public class ExitValueException
extends RuntimeException {
    private static final long serialVersionUID = 2153738224794893827L;
    private final int exitValue;
    private Input input;

    public ExitValueException(String message, int exitValue) {
        super(message);
        if (exitValue == 0) {
            throw new IllegalArgumentException("exit value must be a non-zero value");
        }
        this.exitValue = exitValue;
    }

    public ExitValueException(String message, int exitValue, Throwable cause) {
        super(message, cause);
        if (exitValue == 0) {
            throw new IllegalArgumentException("exit value must be a non-zero value");
        }
        this.exitValue = exitValue;
    }

    public int getExitValue() {
        return this.exitValue;
    }

    @Override
    public String getMessage() {
        if (this.input == null) {
            return super.getMessage();
        }
        return super.getMessage() + "[input:" + (this.input instanceof FileInput ? ((FileInput)this.input).getFileInfo() : this.input.toString()) + "]";
    }

    public void setInput(Input input) {
        this.input = input;
    }

    public Input getInput() {
        return this.input;
    }
}

