/*
 * Decompiled with CFR 0.152.
 */
package org.unix4j.convert;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.unix4j.convert.ArrayConverters;
import org.unix4j.convert.CharacterConverters;
import org.unix4j.convert.ConverterRegistry;
import org.unix4j.convert.DateConverters;
import org.unix4j.convert.EnumConverters;
import org.unix4j.convert.FileArrayConverters;
import org.unix4j.convert.FileConverters;
import org.unix4j.convert.InputStreamConverters;
import org.unix4j.convert.IntegerConverters;
import org.unix4j.convert.LongConverters;
import org.unix4j.convert.OutputStreamConverters;
import org.unix4j.convert.PatternConverters;
import org.unix4j.convert.RangeConverters;
import org.unix4j.convert.StringArrayConverters;
import org.unix4j.convert.StringConverters;
import org.unix4j.convert.URLConverters;
import org.unix4j.convert.ValueConverter;
import org.unix4j.util.Range;

public class DefaultConverterRegistry
implements ConverterRegistry {
    private final Map<Class<?>, ValueConverter<?>> converterByType = new HashMap();

    public DefaultConverterRegistry() {
        this.initConverters();
    }

    protected void initConverters() {
        this.registerValueConverter(Character.class, CharacterConverters.DEFAULT);
        this.registerValueConverter(Character.TYPE, CharacterConverters.DEFAULT);
        this.registerValueConverter(Integer.class, IntegerConverters.DEFAULT);
        this.registerValueConverter(Integer.TYPE, IntegerConverters.DEFAULT);
        this.registerValueConverter(Long.class, LongConverters.DEFAULT);
        this.registerValueConverter(Long.TYPE, LongConverters.DEFAULT);
        this.registerValueConverter(String.class, StringConverters.DEFAULT);
        this.registerValueConverter(String[].class, StringArrayConverters.FLATTEN);
        this.registerValueConverter(File[].class, FileArrayConverters.FLATTEN);
        this.registerValueConverter(Object[].class, ArrayConverters.FLATTEN);
        this.registerValueConverter(Date.class, DateConverters.DEFAULT);
        this.registerValueConverter(File.class, FileConverters.DEFAULT);
        this.registerValueConverter(InputStream.class, InputStreamConverters.DEFAULT);
        this.registerValueConverter(OutputStream.class, OutputStreamConverters.DEFAULT);
        this.registerValueConverter(URL.class, URLConverters.DEFAULT);
        this.registerValueConverter(Pattern.class, PatternConverters.DEFAULT);
        this.registerValueConverter(Range.class, RangeConverters.DEFAULT);
    }

    @Override
    public <V> ValueConverter<V> getValueConverterFor(Class<V> type) {
        ValueConverter<?> converter = this.converterByType.get(type);
        if (converter != null) {
            return converter;
        }
        return this.getEnumConverterFor(type);
    }

    private <V> ValueConverter<V> getEnumConverterFor(Class<V> type) {
        if (type.isEnum()) {
            EnumConverters.StringToEnumConverter<V> enumConverter = new EnumConverters.StringToEnumConverter<V>(type);
            return enumConverter;
        }
        return null;
    }

    public <V> void registerValueConverter(Class<V> type, ValueConverter<V> converter) {
        this.converterByType.put(type, converter);
    }
}

