/*
 * Decompiled with CFR 0.152.
 */
package org.unix4j.convert;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.unix4j.convert.CompositeValueConverter;
import org.unix4j.convert.ConcatenatedConverter;
import org.unix4j.convert.FileConverters;
import org.unix4j.convert.URLConverters;
import org.unix4j.convert.ValueConverter;

public class InputStreamConverters {
    public static final ValueConverter<InputStream> URL_TO_STREAM = new ValueConverter<InputStream>(){

        @Override
        public InputStream convert(Object value) throws IllegalArgumentException {
            if (value instanceof URL) {
                try {
                    return ((URL)value).openStream();
                }
                catch (IOException e) {
                    return null;
                }
            }
            return null;
        }
    };
    public static final ValueConverter<InputStream> URL = ConcatenatedConverter.concat(URLConverters.DEFAULT, URL_TO_STREAM);
    public static final ValueConverter<InputStream> FILE_TO_STREAM = new ValueConverter<InputStream>(){

        @Override
        public InputStream convert(Object value) throws IllegalArgumentException {
            if (value instanceof File) {
                try {
                    return new FileInputStream((File)value);
                }
                catch (IOException e) {
                    return null;
                }
            }
            return null;
        }
    };
    public static final ValueConverter<InputStream> FILE = ConcatenatedConverter.concat(FileConverters.DEFAULT, FILE_TO_STREAM);
    public static final ValueConverter<InputStream> DEFAULT = new CompositeValueConverter<InputStream>().add(URL).add(FILE);
}

