/*
 * Decompiled with CFR 0.152.
 */
package org.unix4j.convert;

import org.unix4j.convert.CompositeValueConverter;
import org.unix4j.convert.ConcatenatedConverter;
import org.unix4j.convert.ValueConverter;
import org.unix4j.option.DefaultOptionSet;
import org.unix4j.option.Option;
import org.unix4j.option.OptionSet;

public class OptionSetConverters {
    private static <O extends Enum<O>> OptionSet<O> toSingletonSet(O option) {
        if (option instanceof OptionSet) {
            OptionSet set = (OptionSet)((Object)option);
            return set;
        }
        return new DefaultOptionSet<O>(option);
    }

    public static class OptionSetConverter<O extends Enum<O>>
    extends CompositeValueConverter<OptionSet<O>> {
        public OptionSetConverter(Class<O> optionEnumClass) {
            this.add(new OptionToSingletonSetConverter<O>(optionEnumClass));
            this.add(new IterableOfOptionNameOrAcronymToOptionSetConverter<O>(optionEnumClass));
            this.add(new ConcatenatedConverter<O>(new NameOrAcronymToOptionConverter<O>(optionEnumClass), new OptionToSingletonSetConverter<O>(optionEnumClass)));
        }
    }

    public static class IterableOfOptionNameOrAcronymToOptionSetConverter<O extends Enum<O>>
    implements ValueConverter<OptionSet<O>> {
        private final Class<O> optionEnumClass;
        private final NameOrAcronymToOptionConverter<O> optionConverter;

        public IterableOfOptionNameOrAcronymToOptionSetConverter(Class<O> optionEnumClass) {
            this.optionEnumClass = optionEnumClass;
            this.optionConverter = new NameOrAcronymToOptionConverter<O>(optionEnumClass);
        }

        @Override
        public OptionSet<O> convert(Object value) throws IllegalArgumentException {
            if (value instanceof Iterable) {
                Iterable iterable = (Iterable)value;
                DefaultOptionSet<O> set = null;
                for (Object optionNameOrAcronym : iterable) {
                    Object option = this.optionConverter.convert(optionNameOrAcronym);
                    if (option == null) {
                        return null;
                    }
                    if (set == null) {
                        set = new DefaultOptionSet<O>(this.optionEnumClass);
                    }
                    set.set(option);
                    set.setUseAcronymFor(option, !((Enum)option).name().equals(optionNameOrAcronym));
                }
                return set;
            }
            return null;
        }
    }

    public static class AcronymStringToOptionSetConverter<O extends Enum<O>>
    implements ValueConverter<OptionSet<O>> {
        private final Class<O> optionEnumClass;
        private final O[] options;

        public AcronymStringToOptionSetConverter(Class<O> optionEnumClass) {
            this.optionEnumClass = optionEnumClass;
            this.options = (Enum[])optionEnumClass.getEnumConstants();
        }

        @Override
        public OptionSet<O> convert(Object value) throws IllegalArgumentException {
            String optionString;
            if (value != null && (optionString = value.toString()).startsWith("-")) {
                DefaultOptionSet<O> set = null;
                for (int i = 1; i < optionString.length(); ++i) {
                    char acronym = optionString.charAt(i);
                    Object found = null;
                    for (O option : this.options) {
                        if (((Option)option).acronym() != acronym) continue;
                        found = option;
                        break;
                    }
                    if (found == null) {
                        return null;
                    }
                    if (set == null) {
                        set = new DefaultOptionSet<O>(this.optionEnumClass);
                    }
                    set.set(found);
                    set.setUseAcronymFor(found, true);
                }
                return set;
            }
            return null;
        }
    }

    public static class OptionNameStringToSingletonSetConverter<O extends Enum<O>>
    implements ValueConverter<OptionSet<O>> {
        private final Class<O> optionEnumClass;

        public OptionNameStringToSingletonSetConverter(Class<O> optionEnumClass) {
            this.optionEnumClass = optionEnumClass;
        }

        @Override
        public OptionSet<O> convert(Object value) throws IllegalArgumentException {
            String optionString;
            if (value != null && (optionString = value.toString()).startsWith("--")) {
                O option;
                String optionName = optionString.substring(2);
                try {
                    option = Enum.valueOf(this.optionEnumClass, optionName);
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
                return OptionSetConverters.toSingletonSet(option);
            }
            return null;
        }
    }

    public static class NameOrAcronymToOptionConverter<O extends Enum<O>>
    implements ValueConverter<O> {
        private final O[] options;

        public NameOrAcronymToOptionConverter(Class<O> optionEnumClass) {
            this.options = (Enum[])optionEnumClass.getEnumConstants();
        }

        @Override
        public O convert(Object value) throws IllegalArgumentException {
            String optionString;
            if (value != null && (optionString = value.toString()).length() > 0) {
                for (O option : this.options) {
                    if (!((Enum)option).name().equals(optionString) && (optionString.length() != 1 || optionString.charAt(0) != ((Option)option).acronym())) continue;
                    return option;
                }
            }
            return null;
        }
    }

    public static class OptionToSingletonSetConverter<O extends Enum<O>>
    implements ValueConverter<OptionSet<O>> {
        private final Class<O> optionEnumClass;

        public OptionToSingletonSetConverter(Class<O> optionEnumClass) {
            this.optionEnumClass = optionEnumClass;
        }

        @Override
        public OptionSet<O> convert(Object value) throws IllegalArgumentException {
            if (this.optionEnumClass.isInstance(value)) {
                Enum option = (Enum)this.optionEnumClass.cast(value);
                return OptionSetConverters.toSingletonSet(option);
            }
            return null;
        }
    }
}

