/*
 * Decompiled with CFR 0.152.
 */
package org.unix4j.util;

public enum OS {
    Windows{

        @Override
        public boolean isCurrent(String osName) {
            return osName.indexOf("win") >= 0;
        }
    }
    ,
    Mac{

        @Override
        public boolean isCurrent(String osName) {
            return osName.indexOf("mac") >= 0;
        }
    }
    ,
    Unix{

        @Override
        public boolean isCurrent(String osName) {
            return osName.indexOf("nix") >= 0 || osName.indexOf("nux") >= 0;
        }
    }
    ,
    Solaris{

        @Override
        public boolean isCurrent(String osName) {
            return osName.indexOf("sunos") >= 0;
        }
    };


    public boolean isCurrent() {
        return this.isCurrent(System.getProperty("os.name").toLowerCase());
    }

    protected abstract boolean isCurrent(String var1);

    public static OS current() {
        for (OS os : OS.values()) {
            if (!os.isCurrent()) continue;
            return os;
        }
        throw new IllegalStateException("Cannot evaluate OS constant for current operating system: " + System.getProperty("os.name"));
    }
}

