/*
 * Decompiled with CFR 0.152.
 */
package org.unix4j.util.sort;

import java.text.Collator;
import java.util.Comparator;
import org.unix4j.line.Line;
import org.unix4j.util.sort.TrimBlanksStringComparator;

public class LineComparator
implements Comparator<Line> {
    private final Comparator<? super String> comparator;
    public static final LineComparator COLLATOR = new LineComparator(LineComparator.getCollator(false, false));
    public static final LineComparator COLLATOR_IGNORE_CASE = new LineComparator(LineComparator.getCollator(true, false));
    public static final LineComparator COLLATOR_IGNORE_LEADING_BLANKS = new LineComparator(LineComparator.getCollator(false, true));
    public static final LineComparator COLLATOR_IGNORE_CASE_AND_LEADING_BLANKS = new LineComparator(LineComparator.getCollator(true, true));

    private LineComparator(Comparator<? super String> comparator) {
        this.comparator = comparator;
    }

    @Override
    public int compare(Line line1, Line line2) {
        return this.comparator.compare(line1.getContent(), line2.getContent());
    }

    private static Comparator<? super String> getCollator(boolean ignoreCase, boolean ignoreLeadingBlanks) {
        Collator collator = Collator.getInstance();
        if (ignoreCase) {
            collator.setStrength(1);
        }
        if (ignoreLeadingBlanks) {
            return new TrimBlanksStringComparator(TrimBlanksStringComparator.Mode.Leading, collator);
        }
        return collator;
    }
}

