/*
 * Decompiled with CFR 0.152.
 */
package org.unix4j.variable;

import java.util.Deque;
import java.util.LinkedList;
import org.unix4j.convert.ValueConverter;
import org.unix4j.variable.VariableContext;
import org.unix4j.variable.VariableResolver;

public class DefaultVariableContext
implements VariableContext {
    private final Deque<VariableResolver> resolvers = new LinkedList<VariableResolver>();

    @Override
    public void addVariableResolver(VariableResolver resolver) {
        this.resolvers.addFirst(resolver);
    }

    @Override
    public void removeVariableResolver(VariableResolver resolver) {
        this.resolvers.removeFirstOccurrence(resolver);
    }

    @Override
    public Object getValue(String name) {
        for (VariableResolver resolver : this.resolvers) {
            Object value = resolver.getValue(name);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @Override
    public <V> V getValue(String name, ValueConverter<V> converter) throws IllegalArgumentException {
        Object value = this.getValue(name);
        if (value == null) {
            return null;
        }
        V converted = converter.convert(value);
        if (converted == null) {
            throw new IllegalArgumentException("value conversion not supported for variable " + name + "=" + value + " using converter=" + converter);
        }
        return converted;
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.resolvers;
    }
}

