/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.shaded.xz.xz;

import java.io.InputStream;
import org.vafer.jdeb.shaded.xz.xz.ArrayCache;
import org.vafer.jdeb.shaded.xz.xz.DeltaEncoder;
import org.vafer.jdeb.shaded.xz.xz.DeltaInputStream;
import org.vafer.jdeb.shaded.xz.xz.DeltaOutputStream;
import org.vafer.jdeb.shaded.xz.xz.FilterEncoder;
import org.vafer.jdeb.shaded.xz.xz.FilterOptions;
import org.vafer.jdeb.shaded.xz.xz.FinishableOutputStream;
import org.vafer.jdeb.shaded.xz.xz.UnsupportedOptionsException;

public class DeltaOptions
extends FilterOptions {
    public static final int DISTANCE_MIN = 1;
    public static final int DISTANCE_MAX = 256;
    private int distance = 1;

    public DeltaOptions() {
    }

    public DeltaOptions(int n) throws UnsupportedOptionsException {
        this.setDistance(n);
    }

    public void setDistance(int n) throws UnsupportedOptionsException {
        if (n < 1 || n > 256) {
            throw new UnsupportedOptionsException("Delta distance must be in the range [1, 256]: " + n);
        }
        this.distance = n;
    }

    public int getDistance() {
        return this.distance;
    }

    @Override
    public int getEncoderMemoryUsage() {
        return DeltaOutputStream.getMemoryUsage();
    }

    @Override
    public FinishableOutputStream getOutputStream(FinishableOutputStream finishableOutputStream, ArrayCache arrayCache) {
        return new DeltaOutputStream(finishableOutputStream, this);
    }

    @Override
    public int getDecoderMemoryUsage() {
        return 1;
    }

    @Override
    public InputStream getInputStream(InputStream inputStream, ArrayCache arrayCache) {
        return new DeltaInputStream(inputStream, this.distance);
    }

    @Override
    FilterEncoder getFilterEncoder() {
        return new DeltaEncoder(this);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            assert (false);
            throw new RuntimeException();
        }
    }
}

