/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.maven;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.maven.plugins.annotations.Parameter;
import org.vafer.jdeb.DataConsumer;
import org.vafer.jdeb.DataProducer;
import org.vafer.jdeb.maven.Mapper;
import org.vafer.jdeb.maven.MissingSourceBehavior;
import org.vafer.jdeb.producers.DataProducerArchive;
import org.vafer.jdeb.producers.DataProducerDirectory;
import org.vafer.jdeb.producers.DataProducerFile;
import org.vafer.jdeb.producers.DataProducerFiles;
import org.vafer.jdeb.producers.DataProducerLink;
import org.vafer.jdeb.producers.DataProducerPathTemplate;

public final class Data
implements DataProducer {
    @Parameter
    private File src;
    @Parameter
    private String dst;
    @Parameter
    private String type;
    @Parameter
    private MissingSourceBehavior missingSrc = MissingSourceBehavior.FAIL;
    @Parameter
    private String linkName;
    @Parameter
    private String linkTarget;
    @Parameter
    private boolean symlink = true;
    private boolean conffile = false;
    @Parameter(alias="includes")
    private String[] includePatterns;
    @Parameter(alias="excludes")
    private String[] excludePatterns;
    @Parameter
    private Mapper mapper;
    @Parameter
    private String[] paths;

    public void setSrc(File src) {
        this.src = src;
    }

    public void setDst(String dst) {
        this.dst = dst;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setMissingSrc(String missingSrc) {
        this.missingSrc = MissingSourceBehavior.valueOf(missingSrc.trim().toUpperCase());
    }

    public void setLinkName(String linkName) {
        this.linkName = linkName;
    }

    public void setLinkTarget(String linkTarget) {
        this.linkTarget = linkTarget;
    }

    public void setSymlink(boolean symlink) {
        this.symlink = symlink;
    }

    public void setConffile(boolean conffile) {
        this.conffile = conffile;
    }

    public boolean getConffile() {
        return this.conffile;
    }

    public void setIncludes(String includes) {
        this.includePatterns = this.splitPatterns(includes);
    }

    public void setExcludes(String excludes) {
        this.excludePatterns = this.splitPatterns(excludes);
    }

    void setPaths(String[] paths) {
        this.paths = paths;
    }

    public String[] splitPatterns(String patterns) {
        String[] result = null;
        if (patterns != null && patterns.length() > 0) {
            ArrayList<String> tokens = new ArrayList<String>();
            StringTokenizer tok = new StringTokenizer(patterns, ", ", false);
            while (tok.hasMoreTokens()) {
                tokens.add(tok.nextToken());
            }
            result = tokens.toArray(new String[tokens.size()]);
        }
        return result;
    }

    @Override
    public void produce(DataConsumer pReceiver) throws IOException {
        org.vafer.jdeb.mapping.Mapper[] mappers = null;
        if (this.mapper != null) {
            mappers = new org.vafer.jdeb.mapping.Mapper[]{this.mapper.createMapper()};
        }
        if (this.typeIs("link")) {
            if (this.linkName == null) {
                throw new RuntimeException("linkName is not set");
            }
            if (this.linkTarget == null) {
                throw new RuntimeException("linkTarget is not set");
            }
            new DataProducerLink(this.linkName, this.linkTarget, this.symlink, this.includePatterns, this.excludePatterns, mappers).produce(pReceiver);
            return;
        }
        if (this.typeIs("template")) {
            this.checkPaths();
            new DataProducerPathTemplate(this.paths, this.includePatterns, this.excludePatterns, mappers).produce(pReceiver);
            return;
        }
        if (this.typeIs("files")) {
            this.checkPaths();
            new DataProducerFiles(this.paths, this.dst, mappers).produce(pReceiver);
            return;
        }
        if (this.src == null || !this.src.exists()) {
            if (this.missingSrc == MissingSourceBehavior.IGNORE) {
                return;
            }
            throw new FileNotFoundException("Data source not found : " + this.src);
        }
        if (this.typeIs("file")) {
            new DataProducerFile(this.src, this.dst, this.includePatterns, this.excludePatterns, mappers).produce(pReceiver);
            return;
        }
        if (this.typeIs("archive")) {
            new DataProducerArchive(this.src, this.includePatterns, this.excludePatterns, mappers).produce(pReceiver);
            return;
        }
        if (this.typeIs("directory")) {
            new DataProducerDirectory(this.src, this.includePatterns, this.excludePatterns, mappers).produce(pReceiver);
            return;
        }
        throw new IOException("Unknown type '" + this.type + "' (file|directory|archive|template|link) for " + this.src);
    }

    private boolean typeIs(String type) {
        return type.equalsIgnoreCase(this.type);
    }

    private void checkPaths() {
        if (this.paths == null || this.paths.length == 0) {
            throw new RuntimeException("paths parameter is not set");
        }
    }
}

