/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.producers;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.DirectoryScanner;
import org.vafer.jdeb.DataConsumer;
import org.vafer.jdeb.DataProducer;
import org.vafer.jdeb.mapping.Mapper;
import org.vafer.jdeb.producers.AbstractDataProducer;
import org.vafer.jdeb.utils.Utils;

public final class DataProducerDirectory
extends AbstractDataProducer
implements DataProducer {
    private final DirectoryScanner scanner = new DirectoryScanner();

    public DataProducerDirectory(File pDir, String[] pIncludes, String[] pExcludes, Mapper[] pMappers) {
        super(pIncludes, pExcludes, pMappers);
        this.scanner.setBasedir(pDir);
        this.scanner.setIncludes(pIncludes);
        this.scanner.setExcludes(pExcludes);
        this.scanner.setCaseSensitive(true);
        this.scanner.setFollowSymlinks(true);
    }

    @Override
    public void produce(DataConsumer pReceiver) throws IOException {
        File file;
        this.scanner.scan();
        File baseDir = this.scanner.getBasedir();
        for (String dir : this.scanner.getIncludedDirectories()) {
            file = new File(baseDir, dir);
            Object dirname = this.getFilename(baseDir, file);
            if ("".equals(dirname)) continue;
            if ('/' != File.separatorChar) {
                dirname = ((String)dirname).replace(File.separatorChar, '/');
            }
            if (!this.isIncluded((String)dirname)) continue;
            if (!((String)dirname).endsWith("/")) {
                dirname = (String)dirname + "/";
            }
            this.produceDir(pReceiver, (String)dirname);
        }
        for (String f : this.scanner.getIncludedFiles()) {
            file = new File(baseDir, f);
            String filename = this.getFilename(baseDir, file);
            if ('/' != File.separatorChar) {
                filename = filename.replace(File.separatorChar, '/');
            }
            if (!this.isIncluded(filename)) continue;
            this.produceFile(pReceiver, file, filename);
        }
    }

    private String getFilename(File root, File file) {
        String relativeFilename = file.getAbsolutePath().substring(root.getAbsolutePath().length());
        return Utils.stripLeadingSlash(relativeFilename);
    }
}

