/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.signing;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import org.vafer.jdeb.PackagingException;
import org.vafer.jdeb.shaded.bc.bcpg.ArmoredOutputStream;
import org.vafer.jdeb.shaded.bc.bcpg.BCPGOutputStream;
import org.vafer.jdeb.shaded.bc.crypto.digests.MD2Digest;
import org.vafer.jdeb.shaded.bc.crypto.digests.MD5Digest;
import org.vafer.jdeb.shaded.bc.crypto.digests.RIPEMD160Digest;
import org.vafer.jdeb.shaded.bc.crypto.digests.SHA1Digest;
import org.vafer.jdeb.shaded.bc.crypto.digests.SHA224Digest;
import org.vafer.jdeb.shaded.bc.crypto.digests.SHA256Digest;
import org.vafer.jdeb.shaded.bc.crypto.digests.SHA384Digest;
import org.vafer.jdeb.shaded.bc.crypto.digests.SHA512Digest;
import org.vafer.jdeb.shaded.bc.openpgp.PGPException;
import org.vafer.jdeb.shaded.bc.openpgp.PGPPrivateKey;
import org.vafer.jdeb.shaded.bc.openpgp.PGPSecretKey;
import org.vafer.jdeb.shaded.bc.openpgp.PGPSecretKeyRing;
import org.vafer.jdeb.shaded.bc.openpgp.PGPSecretKeyRingCollection;
import org.vafer.jdeb.shaded.bc.openpgp.PGPSignature;
import org.vafer.jdeb.shaded.bc.openpgp.PGPSignatureGenerator;
import org.vafer.jdeb.shaded.bc.openpgp.PGPUtil;
import org.vafer.jdeb.shaded.bc.openpgp.operator.KeyFingerPrintCalculator;
import org.vafer.jdeb.shaded.bc.openpgp.operator.bc.BcPBESecretKeyDecryptorBuilder;
import org.vafer.jdeb.shaded.bc.openpgp.operator.bc.BcPGPContentSignerBuilder;
import org.vafer.jdeb.shaded.bc.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.vafer.jdeb.shaded.bc.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.vafer.jdeb.shaded.commons.io.LineIterator;

public class PGPSigner {
    private static final byte[] EOL = "\n".getBytes(StandardCharsets.UTF_8);
    private PGPSecretKey secretKey;
    private PGPPrivateKey privateKey;
    private int digest;
    private SHA1Digest keepSHA1;
    private MD2Digest keepMD2;
    private MD5Digest keepMD5;
    private RIPEMD160Digest keepRIPEMD160;
    private SHA256Digest keepSHA256;
    private SHA384Digest keepSHA384;
    private SHA512Digest keepSHA512;
    private SHA224Digest keepSHA224;

    public static int getDigestCode(String digestName) throws PackagingException {
        if ("SHA1".equals(digestName)) {
            return 2;
        }
        if ("MD2".equals(digestName)) {
            return 5;
        }
        if ("MD5".equals(digestName)) {
            return 1;
        }
        if ("RIPEMD160".equals(digestName)) {
            return 3;
        }
        if ("SHA256".equals(digestName)) {
            return 8;
        }
        if ("SHA384".equals(digestName)) {
            return 9;
        }
        if ("SHA512".equals(digestName)) {
            return 10;
        }
        if ("SHA224".equals(digestName)) {
            return 11;
        }
        throw new PackagingException("unknown hash algorithm tag in digestName: " + digestName);
    }

    public PGPSigner(InputStream keyring, String keyId, String passphrase, int digest) throws IOException, PGPException {
        this.secretKey = this.getSecretKey(keyring, keyId);
        if (this.secretKey == null) {
            throw new PGPException(String.format("Specified key %s does not exist in key ring %s", keyId, keyring));
        }
        this.privateKey = this.secretKey.extractPrivateKey(new BcPBESecretKeyDecryptorBuilder(new BcPGPDigestCalculatorProvider()).build(passphrase.toCharArray()));
        this.digest = digest;
    }

    public void clearSign(String input, OutputStream output) throws IOException, PGPException {
        this.clearSign(new ByteArrayInputStream(input.getBytes(StandardCharsets.UTF_8)), output);
    }

    public void clearSign(InputStream input, OutputStream output) throws IOException, PGPException {
        PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator(new BcPGPContentSignerBuilder(this.privateKey.getPublicKeyPacket().getAlgorithm(), this.digest));
        signatureGenerator.init(1, this.privateKey);
        ArmoredOutputStream armoredOutput = new ArmoredOutputStream(output);
        armoredOutput.beginClearText(this.digest);
        LineIterator iterator = new LineIterator(new InputStreamReader(input));
        while (iterator.hasNext()) {
            String line = iterator.nextLine();
            byte[] data = this.trim(line).getBytes(StandardCharsets.UTF_8);
            armoredOutput.write(data);
            armoredOutput.write(EOL);
            signatureGenerator.update(data);
            if (!iterator.hasNext()) continue;
            signatureGenerator.update(EOL);
        }
        armoredOutput.endClearText();
        PGPSignature signature = signatureGenerator.generate();
        signature.encode(new BCPGOutputStream(armoredOutput));
        armoredOutput.close();
    }

    public PGPSecretKey getSecretKey() {
        return this.secretKey;
    }

    public PGPPrivateKey getPrivateKey() {
        return this.privateKey;
    }

    private PGPSecretKey getSecretKey(InputStream input, String keyId) throws IOException, PGPException {
        PGPSecretKeyRingCollection keyrings = new PGPSecretKeyRingCollection(PGPUtil.getDecoderStream(input), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        Iterator<PGPSecretKeyRing> rIt = keyrings.getKeyRings();
        while (rIt.hasNext()) {
            PGPSecretKeyRing kRing = rIt.next();
            Iterator<PGPSecretKey> kIt = kRing.getSecretKeys();
            while (kIt.hasNext()) {
                PGPSecretKey key = kIt.next();
                if (!key.isSigningKey() || !String.format("%08x", key.getKeyID() & 0xFFFFFFFFL).equals(keyId.toLowerCase())) continue;
                return key;
            }
        }
        return null;
    }

    private String trim(String line) {
        int len;
        char[] chars = line.toCharArray();
        for (len = chars.length; len > 0 && Character.isWhitespace(chars[len - 1]); --len) {
        }
        return line.substring(0, len);
    }
}

