/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.shaded.bc.bcpg;

import java.io.IOException;
import java.math.BigInteger;
import org.vafer.jdeb.shaded.bc.bcpg.BCPGInputStream;
import org.vafer.jdeb.shaded.bc.bcpg.BCPGObject;
import org.vafer.jdeb.shaded.bc.bcpg.BCPGOutputStream;
import org.vafer.jdeb.shaded.bc.bcpg.StreamUtil;

public class MPInteger
extends BCPGObject {
    BigInteger value = null;

    public MPInteger(BCPGInputStream bCPGInputStream) throws IOException {
        int n = StreamUtil.read2OctetLength(bCPGInputStream);
        byte[] byArray = new byte[(n + 7) / 8];
        bCPGInputStream.readFully(byArray);
        this.value = new BigInteger(1, byArray);
    }

    public MPInteger(BigInteger bigInteger) {
        if (bigInteger == null || bigInteger.signum() < 0) {
            throw new IllegalArgumentException("value must not be null, or negative");
        }
        this.value = bigInteger;
    }

    public BigInteger getValue() {
        return this.value;
    }

    @Override
    public void encode(BCPGOutputStream bCPGOutputStream) throws IOException {
        StreamUtil.write2OctetLength(bCPGOutputStream, this.value.bitLength());
        byte[] byArray = this.value.toByteArray();
        if (byArray[0] == 0) {
            bCPGOutputStream.write(byArray, 1, byArray.length - 1);
        } else {
            bCPGOutputStream.write(byArray, 0, byArray.length);
        }
    }
}

