/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.shaded.bc.bcpg;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.vafer.jdeb.shaded.bc.bcpg.SignatureSubpacket;
import org.vafer.jdeb.shaded.bc.bcpg.SignatureSubpacketTags;
import org.vafer.jdeb.shaded.bc.bcpg.StreamUtil;
import org.vafer.jdeb.shaded.bc.bcpg.sig.EmbeddedSignature;
import org.vafer.jdeb.shaded.bc.bcpg.sig.Exportable;
import org.vafer.jdeb.shaded.bc.bcpg.sig.Features;
import org.vafer.jdeb.shaded.bc.bcpg.sig.IntendedRecipientFingerprint;
import org.vafer.jdeb.shaded.bc.bcpg.sig.IssuerFingerprint;
import org.vafer.jdeb.shaded.bc.bcpg.sig.IssuerKeyID;
import org.vafer.jdeb.shaded.bc.bcpg.sig.KeyExpirationTime;
import org.vafer.jdeb.shaded.bc.bcpg.sig.KeyFlags;
import org.vafer.jdeb.shaded.bc.bcpg.sig.LibrePGPPreferredEncryptionModes;
import org.vafer.jdeb.shaded.bc.bcpg.sig.NotationData;
import org.vafer.jdeb.shaded.bc.bcpg.sig.PolicyURI;
import org.vafer.jdeb.shaded.bc.bcpg.sig.PreferredAEADCiphersuites;
import org.vafer.jdeb.shaded.bc.bcpg.sig.PreferredAlgorithms;
import org.vafer.jdeb.shaded.bc.bcpg.sig.PreferredKeyServer;
import org.vafer.jdeb.shaded.bc.bcpg.sig.PrimaryUserID;
import org.vafer.jdeb.shaded.bc.bcpg.sig.RegularExpression;
import org.vafer.jdeb.shaded.bc.bcpg.sig.Revocable;
import org.vafer.jdeb.shaded.bc.bcpg.sig.RevocationKey;
import org.vafer.jdeb.shaded.bc.bcpg.sig.RevocationReason;
import org.vafer.jdeb.shaded.bc.bcpg.sig.SignatureCreationTime;
import org.vafer.jdeb.shaded.bc.bcpg.sig.SignatureExpirationTime;
import org.vafer.jdeb.shaded.bc.bcpg.sig.SignatureTarget;
import org.vafer.jdeb.shaded.bc.bcpg.sig.SignerUserID;
import org.vafer.jdeb.shaded.bc.bcpg.sig.TrustSignature;
import org.vafer.jdeb.shaded.bc.util.Arrays;
import org.vafer.jdeb.shaded.bc.util.io.Streams;

public class SignatureSubpacketInputStream
extends InputStream
implements SignatureSubpacketTags {
    private final InputStream in;
    private final int limit;

    public SignatureSubpacketInputStream(InputStream inputStream) {
        this(inputStream, StreamUtil.findLimit(inputStream));
    }

    public SignatureSubpacketInputStream(InputStream inputStream, int n) {
        this.in = inputStream;
        this.limit = n;
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    public SignatureSubpacket readPacket() throws IOException {
        boolean[] blArray = new boolean[3];
        int n = StreamUtil.readBodyLen(this, blArray);
        if (blArray[StreamUtil.flag_eof]) {
            return null;
        }
        if (blArray[StreamUtil.flag_partial]) {
            throw new IOException("unexpected length header");
        }
        boolean bl = blArray[StreamUtil.flag_isLongLength];
        int n2 = this.in.read();
        if (n2 < 0) {
            throw new EOFException("unexpected EOF reading signature sub packet");
        }
        if (n <= 0 || n > this.limit && n > 2048) {
            throw new EOFException("out of range data found in signature sub packet");
        }
        byte[] byArray = new byte[n - 1];
        int n3 = Streams.readFully(this.in, byArray);
        boolean bl2 = (n2 & 0x80) != 0;
        int n4 = n2 & 0x7F;
        if (n3 != byArray.length) {
            switch (n4) {
                case 2: {
                    byArray = this.checkData(byArray, 4, n3, "Signature Creation Time");
                    break;
                }
                case 16: {
                    byArray = this.checkData(byArray, 8, n3, "Issuer");
                    break;
                }
                case 9: {
                    byArray = this.checkData(byArray, 4, n3, "Signature Key Expiration Time");
                    break;
                }
                case 3: {
                    byArray = this.checkData(byArray, 4, n3, "Signature Expiration Time");
                    break;
                }
                default: {
                    throw new EOFException("truncated subpacket data.");
                }
            }
        }
        switch (n4) {
            case 2: {
                return new SignatureCreationTime(bl2, bl, byArray);
            }
            case 32: {
                return new EmbeddedSignature(bl2, bl, byArray);
            }
            case 9: {
                return new KeyExpirationTime(bl2, bl, byArray);
            }
            case 3: {
                return new SignatureExpirationTime(bl2, bl, byArray);
            }
            case 7: {
                return new Revocable(bl2, bl, byArray);
            }
            case 4: {
                return new Exportable(bl2, bl, byArray);
            }
            case 30: {
                return new Features(bl2, bl, byArray);
            }
            case 16: {
                return new IssuerKeyID(bl2, bl, byArray);
            }
            case 5: {
                return new TrustSignature(bl2, bl, byArray);
            }
            case 11: 
            case 21: 
            case 22: {
                return new PreferredAlgorithms(n4, bl2, bl, byArray);
            }
            case 34: {
                return new LibrePGPPreferredEncryptionModes(bl2, bl, byArray);
            }
            case 39: {
                return new PreferredAEADCiphersuites(bl2, bl, byArray);
            }
            case 24: {
                return new PreferredKeyServer(bl2, bl, byArray);
            }
            case 27: {
                return new KeyFlags(bl2, bl, byArray);
            }
            case 26: {
                return new PolicyURI(bl2, bl, byArray);
            }
            case 25: {
                return new PrimaryUserID(bl2, bl, byArray);
            }
            case 28: {
                return new SignerUserID(bl2, bl, byArray);
            }
            case 20: {
                return new NotationData(bl2, bl, byArray);
            }
            case 6: {
                return new RegularExpression(bl2, bl, byArray);
            }
            case 29: {
                return new RevocationReason(bl2, bl, byArray);
            }
            case 12: {
                return new RevocationKey(bl2, bl, byArray);
            }
            case 31: {
                return new SignatureTarget(bl2, bl, byArray);
            }
            case 33: {
                return new IssuerFingerprint(bl2, bl, byArray);
            }
            case 35: {
                return new IntendedRecipientFingerprint(bl2, bl, byArray);
            }
        }
        return new SignatureSubpacket(n4, bl2, bl, byArray);
    }

    private byte[] checkData(byte[] byArray, int n, int n2, String string) throws EOFException {
        if (n2 != n) {
            throw new EOFException("truncated " + string + " subpacket data.");
        }
        return Arrays.copyOfRange(byArray, 0, n);
    }
}

