/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.shaded.bc.bcpg;

import org.vafer.jdeb.shaded.bc.bcpg.SymmetricKeyAlgorithmTags;

public class SymmetricKeyUtils
implements SymmetricKeyAlgorithmTags {
    public static int getKeyLengthInBits(int n) {
        switch (n) {
            case 0: {
                throw new IllegalArgumentException("NULL is no encryption algorithm.");
            }
            case 6: {
                return 64;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 11: {
                return 128;
            }
            case 2: 
            case 8: 
            case 12: {
                return 192;
            }
            case 9: 
            case 10: 
            case 13: {
                return 256;
            }
        }
        throw new IllegalArgumentException("unknown symmetric algorithm: " + n);
    }

    public static int getKeyLengthInOctets(int n) {
        return (SymmetricKeyUtils.getKeyLengthInBits(n) + 7) / 8;
    }
}

