/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.shaded.bc.bcpg;

import java.io.IOException;
import org.vafer.jdeb.shaded.bc.bcpg.BCPGInputStream;
import org.vafer.jdeb.shaded.bc.bcpg.BCPGOutputStream;
import org.vafer.jdeb.shaded.bc.bcpg.ContainedPacket;
import org.vafer.jdeb.shaded.bc.bcpg.UserDataPacket;
import org.vafer.jdeb.shaded.bc.util.Arrays;
import org.vafer.jdeb.shaded.bc.util.Strings;

public class UserIDPacket
extends ContainedPacket
implements UserDataPacket {
    private byte[] idData;

    public UserIDPacket(BCPGInputStream bCPGInputStream) throws IOException {
        this(bCPGInputStream, false);
    }

    public UserIDPacket(BCPGInputStream bCPGInputStream, boolean bl) throws IOException {
        super(13, bl);
        this.idData = bCPGInputStream.readAll();
    }

    public UserIDPacket(String string) {
        super(13);
        this.idData = Strings.toUTF8ByteArray(string);
    }

    public UserIDPacket(byte[] byArray) {
        super(13);
        this.idData = Arrays.clone(byArray);
    }

    public String getID() {
        return Strings.fromUTF8ByteArray(this.idData);
    }

    public byte[] getRawID() {
        return Arrays.clone(this.idData);
    }

    public boolean equals(Object object) {
        if (object instanceof UserIDPacket) {
            return Arrays.areEqual(this.idData, ((UserIDPacket)object).idData);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.idData);
    }

    @Override
    public void encode(BCPGOutputStream bCPGOutputStream) throws IOException {
        bCPGOutputStream.writePacket(this.hasNewPacketFormat(), 13, this.idData);
    }
}

